package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemInvoiceDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemInvoiceConditionReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 商品开票信息接口
 *
 * @author yuangui
 * @since 2022-05-23
 */
@Api(tags = {"商品开票信息"})
@FeignClient(
        contextId = "com-yx-tcbj-center-api-IItemInvoiceQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemInvoice",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemInvoiceQueryApi {
    /**
     * 根据ids批量查询商品开票信息
     * @param ids
     * @return
     */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids批量查询商品开票信息", notes = "根据ids批量查询商品开票信息")
    RestResponse<List<ItemInvoiceDto>> queryByIds(@RequestBody List<Long> ids);
    /**
     * 根据id查询商品开票信息
     * @param id
     * @return
     */
    @GetMapping("/queryById/{id}")
    @ApiOperation(value = "根据id查询商品开票信息", notes = "根据id查询商品开票信息")
    RestResponse<ItemInvoiceDto> queryById(@PathVariable("id") Long id);
    /**
     * 根据itemCodes批量查询商品开票信息
     * @param itemCodes
     * @return ItemInvoiceQueryConditionReqDto
     */
    @PostMapping("/queryInvoiceByItemCodes")
    @ApiOperation(value = "根据itemCodes批量查询商品开票信息", notes = "根据itemCodes批量查询商品开票信息")
    RestResponse<List<ItemInvoiceDto>> queryInvoiceByItemCodes(@RequestBody List<String> itemCodes);
    /**
     * 根据查询条件分页查询商品开票信息
     * @param reqDto
     * @return PageInfo<ItemInvoiceDto>
     */
    @PostMapping("/queryByPages")
    @ApiOperation(value = "根据查询条件分页查询商品开票信息", notes = "根据查询条件分页查询商品开票信息")
    RestResponse<PageInfo<ItemInvoiceDto>> queryByPages(@RequestBody ItemInvoiceConditionReqDto reqDto);
    /**
     * 商品开票信息数据导出
     * @param reqDto
     * @return
     */
    @PostMapping("/export")
    @ApiOperation(value = "商品开票信息数据导出", notes = "商品开票信息数据导出")
    RestResponse<String> export(@RequestBody ItemInvoiceConditionReqDto reqDto);
}
