/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShopRespDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品请求参数Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemRespDto", description = "商品请求参数Dto")
public class ItemReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "attrs", value = "商品属性，选填")
    private String attrs;

    /**
     * 品牌Id列表
     */
    @ApiModelProperty(name = "brandIdList", value = "品牌id列表")
    private List<Long> brandIdList;


    /**
     * 虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;
    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;
    @ApiModelProperty(name = "statusList", value = "状态列表")
    private List<Integer> statusList;
    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；4 虚拟商品")
    private Integer type;
    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "typeList", value = "商品类型列表")
    private List<Integer> typeList;
    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;
    /**
     * 商品版本
     */
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;
    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "目录Id")
    private Long dirId;

    /**
     * 目录Id列表
     */
    @ApiModelProperty(name = "dirIdList", value = "目录Id列表")
    private List<Long> dirIdList;

    /**
     * 运费模板
     */
    @ApiModelProperty(name = "shippingTpl", value = "运费模板")
    private Long shippingTpl;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;
    /**
     * 商品ID集合
     */
    @ApiModelProperty(name = "itemIds", value = "商品ID集合")
    private List<Long> itemIds;

    @ApiModelProperty(name = "shopIds", value = "店铺id列表")
    private List<Long> shopIds;

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "spuid", value = "产品id")
    private Long spuid;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;

    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;

    @ApiModelProperty(name = "yearBegin", value = "所属年份（起始）")
    private Integer yearBegin;

    @ApiModelProperty(name = "yearEnd", value = "所属年份（结束）")
    private Integer yearEnd;

    @ApiModelProperty(name = "safetyStockBegin", value = "安全库存数(起始)，支持小数点")
    private BigDecimal safetyStockBegin;

    @ApiModelProperty(name = "safetyStockEnd", value = "安全库存数(结束)，支持小数点")
    private BigDecimal safetyStockEnd;

    @ApiModelProperty(name = "priceBegin", value = "单价(起始)")
    private BigDecimal priceBegin;

    @ApiModelProperty(name = "priceEnd", value = "单价(结束)")
    private BigDecimal priceEnd;

    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;

    @ApiModelProperty(name = "bizType", value = "业务类型，1-商城商品查询，2-商品库商品查询")
    private Integer bizType;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "organizationId",value = "组织id")
    private Long organizationId;

    @ApiModelProperty(name = "organizationIdList", value = "组织Id列表")
    private List<Long> organizationIdList;

    @ApiModelProperty(name = "skuIdList", value = "SKUId列表")
    private List<Long> skuIdList;

    @ApiModelProperty(name = "outSkuIdList", value = "在SKUId集合外查询")
    private List<Long> outSkuIdList;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "subTypeList", value = "商品子类型，1-产品，2-赠品，3-物料")
    private List<Integer> subTypeList;

    /**
     * 过滤的条件，商品授权专用字段，限制已授权的SKU不出现在列表中，现在暂时只有sku限制过滤，[{"businessType":"SKU", "targetType":1, "targetIdList":[]}]
     */
    @ApiModelProperty(name = "limitList", value = "过滤的条件，商品授权专用字段，限制已授权的SKU不出现在列表中，现在暂时只有sku限制过滤，[{\"businessType\":\"SKU\", \"targetType\":1, \"targetIdList\":[]}]")
    private List<ItemAuthLimitDto> limitList;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(name = "keyword", value = "关键字，支持商品名字/商品编码模糊搜索")
    private String keyword;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    // ==== 北鼎字段start ====
    private String dirLevel;

    private String dirPrefixLevel;

    private Long dirPrefixId;

    /**
     *  前台类目名称
     */
    private String dirPrefixName;

    /**
     *  产品大类
     */
    private String prodLargeClass;

    /**
     * 产品大类编码(北鼎一级品类)
     */
    private String prodLargeCode;

    /**
     *  产品二级分类
     */
    private String prodSecClassify;

    /**
     *产品二级分类编码(北鼎二级品类)
     */
    private String prodSecCode;

    /**
     * 产品三级分类(北鼎三级品类描述)
     */
    private String prodThrClassify;

    /**
     *产品三级分类编码(北鼎三级品类)
     */
    private String prodThrCode;

    /**
     *  产品负责人
     */
    private String principalPerson;

    /**
     *  国内B2B卖点
     */
    private String domesticB2b;


    /**
     *  国外B2B卖点
     */
    private String internalB2b;

    /**
     *  EN（69码）
     */
    private String enCode;

    /**
     *  规格
     */
    private String specContent;

    private String itemCode;

    private String itemName;

    private String shelfStatus;


    private List<ItemMediasRespDto> itemMediasList = Lists.newArrayList();;


    private List<ItemShopRespDto> itemShopList = Lists.newArrayList();

    private String prodClassCode;

    private String prodClassName;

    private Long salesCount;

    private Date addTime;


    /**
     * 产品组
     */
    private String prodGroup;

    /**
     * 物料组
     */
    private String materialGroup;

    /**
     * 产品层次
     */
    private String prodLevel;

    private String platforms;

    private String platformIds;

    private String platformNames;

    /**
     * 可用商品库存数
     */
    private Long avaNum;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * BD50:玻璃险虚拟商品 BD51:无物料商品 BD52:等蜂来 BD53:分快递费虚拟商品/借贷项等其他虚拟商品
     */
    private String virtualType;

    private Integer itemUse;

    // ==== 北鼎字段end ====

    // ==== 华帝字段start ====
    /*产品类别*/
    String itemCategory = null;
    /*软件著作权书号*/
    String softwareWorkCode = null;
    /*软件著作权名称*/
    String softwareWorkName = null;
    /*适用水压*/
    String hydraulicPressure = null;
    /*燃气种类*/
    String gasClass = null;
    /*适用地区*/
    String applyArea = null;
    /*泄露电流*/
    String leakageCurrent = null;
    /*防护等级*/
    String protectionLevel = null;
    /*燃气额定电压*/
    String gasNominalVoltage = null;
    /*热效率*/
    String thermalEfficiency = null;
    /*额定燃气高热值*/
    String heatingRating = null;
    /*安全阀泄压值*/
    String releasePressure = null;
    /*额定电功率*/
    String electricalRating = null;
    /*物料开票描述*/
    String invoiceDescription = null;
    /*燃气热值类型*/
    String gasHeatingType = null;
    /*额定电压*/
    String nominalVoltage = null;
    /*额定频率*/
    String ratedFrequency = null;
    /*额度热负荷*/
    String nominalHeatLoad = null;
    /*熄火保护装置类型*/
    String flameoutProtectionType = null;
    /*额定燃气低热值*/
    String lowRating = null;
    /*额定燃气相对密度*/
    String  gasRatedRelativeDensity = null;
    /*额定产热水能力*/
    String productionWaterCapacity = null;
    /*额定压力*/
    String nominalPressure = null;
    /*开票规格型号*/
    String invoicingRulesCode = null;
    /*供应商*/
    String supplier = null;
    /*产品定位*/
    String productPositioning = null;
    /*产品型号*/
    String productModel = null;
    /*销售组*/
    String saleGroup = null;
    /*税收分类名称*/
    String taxCategoryName = null;
    /*组织名称*/
    String organizationName = null;
    /*销售渠道*/
    String saleChannel = null;
    /*介绍*/
    String brief = null;
    /*介绍*/
    String detail = null;

    /**
     *产品层次2
     * */
    String prodLevelTwo = null;
    /**
     *产品层次3
     * */
    String prodLevelThree = null;
    /**
     *产品层次4
     * */
    String prodLevelFour = null;
    /**
     *产品层次5
     * */
    String prodLevelFive = null;

    Integer pushWms = null;

    String thirdSystem = null;

    // ==== 华帝字段end ====


    /**
     * 旧编码
     */
    private String oldLongCode;
}
