package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 商品中心：上架服务
 * @author  惜笔 | 林五弟
 * @date  2021/9/15 11:01
 * @version 1.0.0
 */
@Api(tags = {"商品中心：上架服务"})
@FeignClient(
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IShelfQueryApi",
        path = "/v1/shelf",
        url = "${yundt.cube.center.item.api:}"
)
public interface IShelfQueryApi {


    /**
     * 根据店铺id和skuId查询上架信息
     * @author 惜笔 | 林五弟
     * @date 2021/9/15 11:09
     * @param shelfQueryReqDto
     * @return com.dtyunxi.rest.RestResponse<java.util.List <ShelfQueryRespDto>>
     */
    @PostMapping("shelf-list")
    @ApiOperation(value = "根据店铺id和skuId查询上架信息", notes = "根据店铺id和skuId查询上架信息")
    RestResponse<List<ShelfQueryRespDto>> queryShelfList(@RequestBody ShelfQueryReqDto shelfQueryReqDto);

    /**
     * 查询首页推荐商品列表
     * @param type
     * @return
     */
    @GetMapping("homepage/{type}")
    @ApiOperation(value = "查询首页推荐商品列表", notes = "查询首页推荐商品列表")
    RestResponse<List<ItemShelfRespDto>> queryHomepageList(@PathVariable("type") Integer type);


}
