package com.dtyunxi.yundt.cube.center.item.api.dto.response.dg;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 多媒体请求入参封装
 * @author 诺克
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemExchangeUnitDgRespDto", description = "单位换算返回参数ItemExchangeUnitDgRespDto")
public class ItemExchangeUnitDgRespDto extends BaseVo {
    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "code", value = "sku编码")
    private String code;

    @ApiModelProperty(name = "name", value = "规格名(sku名称)")
    private String name;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;
    /**
     * 名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * 名称
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     * 显示名
     */
    @ApiModelProperty(name = "displayName", value = "显示名(商品简称)")
    private String displayName;

    @ApiModelProperty(name = "costPrice",value = "成本价")
    private BigDecimal costPrice;
    /**
     * 体积
     */
    @ApiModelProperty(name="volume", value = "体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty(name="volumeUnit", value = "体积单位")
    private String volumeUnit;
    /**
     * 毛重
     */
    @ApiModelProperty(name="grossWeight", value = "毛重")
    private BigDecimal grossWeight;

    /**
     * 毛重单位
     */
    @ApiModelProperty(name="grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;

    /**
     * 净重
     */
    @ApiModelProperty(name="netWeight", value = "净重")
    private BigDecimal netWeight;

    /**
     * 净重单位
     */
    @ApiModelProperty(name="netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /*
     *
     * 目标单位
     * */
    @ApiModelProperty(name = "targetUnit", value = "目标单位")
    private String targetUnit;

    @ApiModelProperty(name = "baseUnitNum", value = "目标单位数量")
    private Integer targetNum;
    @ApiModelProperty(name = "currentUnit", value = "当前单位")
    private String currentUnit;

    @ApiModelProperty(name = "currentNum", value = "当前单位数量")
    private Integer currentNum;

    /**
     *  整箱取整数
     */
    @ApiModelProperty(name = "bigBox", value = "装箱数")
    private Long bigBox;
    /**
     *  仓托盘取整数量
     */
    @ApiModelProperty(name = "zhTrayNum", value = "珠海仓托盘数量")
    private Long zhTrayNum;
}
