//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.dtyunxi.yundt.cube.center.item.api.b2b.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerBlockItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerBlockItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMgmtBlockRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ManagementBlockRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;

import javax.validation.Valid;
import java.util.List;

@Api(
    tags = {"商品中心：经营屏蔽"}
)
@FeignClient(
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/management-block",
    contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-query-IManagementBlockQueryApi",
    url = "${yundt.cube.center.item.api:}"
)
public interface IManagementBlockQueryApi {
    @GetMapping({"/page"})
    @ApiOperation("经营屏蔽商品分页列表")
    RestResponse<PageInfo<ManagementBlockRespDto>> pageManagementBlock(@ModelAttribute @Valid ManagementBlockReqDto customerImportLogSearchReqDto);

    @GetMapping({"/{itemId}"})
    @ApiOperation(
        value = "根据商品id查询商品经营屏蔽信息",
        notes = "根据商品id查询商品经营屏蔽信息(商品详情用)",
        response = ItemMgmtBlockRespDto.class
    )
    RestResponse<List<ItemMgmtBlockRespDto>> queryItemMgmtBlockList(@PathVariable("itemId") Long itemId);

    @GetMapping({"/cust_block_item"})
    @ApiOperation(
        value = "根据客户查询屏蔽商品",
        notes = "根据客户查询屏蔽商品",
        response = CustomerBlockItemRespDto.class
    )
    RestResponse<List<CustomerBlockItemRespDto>> queryCustomerBlockItemList(@ModelAttribute CustomerBlockItemReqDto customerBlockItemReqDto);
}
