/*
 * @(#)IBrandApi.java 1.0 2018-08-24
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * 品牌服务
 *
 * @author 风影
 * @since 2.0.0
 */
@Api(tags = {"商品中心：品牌服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IBrandApi",
        path = "/v1/brand",
        url = "${yundt.cube.center.item.api:}")
public interface IBrandApi {

    /**
     * 新增品牌
     *
     * @param reqDto 品牌实体对象
     * @return 统一返回响应对象，业务数据data为新增后的品牌Id
     */
    @PostMapping("")
    @ApiOperation(value = "新增品牌", notes = "新增品牌")
    RestResponse<Long> addBrand(@Validated @RequestBody TagReqDto.BrandReqDto reqDto);

    /**
     * 更新品牌
     *
     * @param reqDto 品牌实体对象
     * @return Void
     */
    @PutMapping("")
    @ApiOperation(value = "更新品牌", notes = "更新品牌")
    RestResponse<Void> modifyBrand(@Validated @RequestBody TagReqDto.BrandReqDto reqDto);

    /**
     * 更新品牌状态
     *
     * @param id     品牌Id
     * @param status 状态
     * @return 统一返回响应对象，业务数据data为更新后的品牌Id
     */
    @PutMapping(value = "/{id}/status/{status}")
    @ApiOperation(value = "更新品牌状态", notes = "更新品牌状态 \n id:品牌id status:状态(0禁用 1启用)")
    RestResponse<Long> modifyStatus(@NotNull(message = "品牌Id不能为空") @PathVariable("id") Long id,
                                    @NotNull(message = "要修改不能为空") @PathVariable("status") Integer status);

    /**
     * 删除品牌
     *
     * @param ids 品牌Id
     * @return Void
     */
    @DeleteMapping(value = "/{ids}")
    @ApiOperation(value = "删除品牌", notes = "根据品牌Id删除品牌信息 \t\n id:品牌Id，复数用逗号隔开")
    RestResponse<Void> removeById(@NotNull(message = "品牌Id不能为空") @PathVariable("ids") String ids);

    /**
     * 删除品牌
     *
     * @param brandCode 品牌编码
     * @return Void
     */
    @DeleteMapping(value = "/code/{brandCode}")
    @ApiOperation(value = "根据brandCode删除品牌信息", notes = "根据brandCode删除品牌信息 \t\n brandCode:品牌Code")
    RestResponse<Void> removeByCode(@NotNull(message = "品牌编码不能为空") @PathVariable("brandCode") String brandCode);

}
