package com.dtyunxi.yundt.cube.center.item.api.base.constants;

public enum  RateByDayEnum {

    EVERYDAY(1, "每天"),
    EVERY_OTHER_DAY(2, "隔天"),
    EVERY_TWO_DAYS(3, "隔2天"),
    EVERY_THREE_DAYS(4, "隔3天"),
    WORKDAY(5, "工作日"),
    REST_DAY(6, "周末");

    private int code;

    private String name;

    RateByDayEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RateByDayEnum getByCode(int code) {
        for (RateByDayEnum data : RateByDayEnum.values()) {
            if (code == data.getCode()) {
                return data;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
