/**
 * @(#)IItemSkuApi 1.0 2019/4/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemRelationSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfSkuSearchReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * sku查询
 *
 * @author 浮云
 */
@Api(tags = {"商品中心：商品规格服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IItemSkuQueryApi",
        path = "/v1/item/sku",
        url = "${yundt.cube.center.item.api:}")
public interface IItemSkuQueryApi {

    /**
     * 根据sku编码查询sku信息
     *
     * @param skuCodes 根据sku编码查询sku信息
     * @return
     */
    @PostMapping(value = "/queryBySkuCode")
    @ApiOperation(value = "根据sku编码查询sku信息", notes = "根据sku编码查询sku信息")
    RestResponse<List<ItemSkuRespDto>> queryBySkuCode(@RequestBody List<String> skuCodes);

    @PostMapping(value = "/queryByCargoCode")
    @ApiOperation(value = "根据货品编码查询sku信息", notes = "根据货品编码查询sku信息")
    RestResponse<List<ItemSkuExtRespDto>> queryByCargoCode(@RequestBody List<String> cargoCodes);

    @PostMapping(value = "/querySkuExtBySkuId")
    @ApiOperation(value = "根据skuId查询sku和item信息", notes = "根据skuId查询sku和item信息")
    RestResponse<List<ItemSkuExtRespDto>> querySkuExtBySkuId(@RequestBody List<Long> skuIds);


    /**
     * 根据sku编码查询sku信息
     *
     * @param skuIds 根据skuId查询sku信息
     * @return
     */
    @PostMapping(value = "/queryBySkuId")
    @ApiOperation(value = "根据sku编码查询sku信息", notes = "根据sku编码查询sku信息")
    RestResponse<List<ItemSkuRespDto>> queryBySkuId(@RequestBody List<Long> skuIds);

    /**
     * 根据itemId查询sku信息
     *
     * @param itemId 根据itemId查询sku信息
     * @return
     */
    @PostMapping(value = "/queryByItemIdList")
    @ApiOperation(value = "根据itemId查询sku信息", notes = "根据itemId查询sku信息")
    public RestResponse<List<ItemSkuRespDto>> queryByItemIdList(@RequestBody List<Long> itemId);

    /**
     * 商品关系sku的信息查询
     *
     * @param itemRelationSkuReqDto 商品关系sku的信息请求dto
     * @param pageNum               指定页码
     * @param pageSize              指定每页返回的对象个数
     * @return
     */
    @PostMapping(value = "/relation/page")
    @ApiOperation(value = "商品关系sku的信息查询", notes = "商品关系sku的信息查询")
    RestResponse<PageInfo<ItemRelationSkuRespDto>> queryItemRelationSku(@RequestBody ItemRelationSkuReqDto itemRelationSkuReqDto, @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);


    /**
     * 根据后台类目id，查询类目下的上架商品sku基础信息
     *
     * @param dirId 后台类目id
     * @param name 商品名称
     * @return 商品sku基础信息
     */
    @GetMapping(value = "/queryByDirId")
    @ApiOperation(value = "根据后台类目id，查询类目下的上架商品sku基础信息", notes = "根据后台类目id，查询类目下的上架商品sku基础信息")
    RestResponse<List<DirShelfItemRespDto>> queryByDirId(@RequestParam("dirId") Long dirId, @RequestParam(name = "name", required = false) String name);


    /**
     * 根据后台类目id，分页查询类目下的上架商品sku基础信息
     *
     * @param itemShelfSkuSearchReqDto 上架商品sku信息查询请求dto
     * @return 商品sku基础信息
     */
    @PostMapping(value = "/querySkuPageByDirId/page")
    @ApiOperation(value = "根据后台类目id，分页查询类目下的上架商品sku基础信息", notes = "根据后台类目id，分页查询类目下的上架商品sku基础信息")
    RestResponse<PageInfo<DirShelfItemRespDto>> querySkuPageByDirId(@RequestBody ItemShelfSkuSearchReqDto itemShelfSkuSearchReqDto);

    @GetMapping(value = "/queryByItemId")
    @ApiOperation(value = "根据itemId查询",notes = "根据itemId查询")
    RestResponse<List<ItemSkuRespDto>> queryByItemId(@RequestParam("itemId")Long itemId);

    @PostMapping(value = "/queryDetailByItemIds")
    @ApiOperation(value = "根据itemId查询",notes = "根据itemId查询")
    RestResponse<List<ItemSkuRespDto>> queryDetailByItemIds(@RequestBody List<Long> itemIds);

    @PostMapping(value = "/updateCostPrice")
    @ApiOperation(value = "更新成本价、和新增字段",notes = "更新成本价、和新增字段t通过skuId")
    RestResponse<String>updateCostPrice(@RequestBody ItemSkuReqDto itemSkuReqDto);


    /**
     * 价格中心的sku商品列表
     * @author 惜笔 | 林五弟
     * @date 2021/11/18 17:35
     * @param itemSkuQueryReqDto
     * @param pageNum
     * @param pageSize
     * @return 返回sku分页信息
     */
    @PostMapping(value = "/query-page")
    @ApiOperation(value = "查询sku分页信息",notes = "查询sku分页信息")
    RestResponse<PageInfo<ItemSkuQueryRespDto>> querySkuPage(@RequestBody ItemSkuQueryReqDto itemSkuQueryReqDto,
                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
