/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.TagRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 标签API查询接口类
 *
 * @author 佐助
 * @since 2.0.0
 */
@Api(tags = {"商品中心：标签查询服务接口"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IItemTagQueryApi",
        path = "/v1/tag",
        url = "${yundt.cube.center.item.api:}")
public interface IItemTagQueryApi {

    /**
     * 查询标签列表 filter-> TagReqDto
     *
     * @param filter   查询条件
     * @param pageNum  指定页码
     * @param pageSize 指定每页返回的对象个数
     * @return 统一返回响应对象，业务数据data为标签Dto分页列表
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "查询标签列表", notes = "查询标签列表，filter=TagReqDto")
    RestResponse<PageInfo<TagRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询标签详情
     *
     * @param id 主键
     * @return 统一返回响应对象，业务数据data为标签Dto
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询标签详情", notes = "查询标签详情 \t\n id：标签id")
    RestResponse<TagRespDto> queryById(@NotNull(message = "标签id不能为空") @PathVariable("id") Long id);

    /**
     * 根据商品id查询商品标签
     *
     * @param itemId 商品ID
     * @return 统一返回响应对象，业务数据data为标签Dto
     */
    @GetMapping(value = "/item/{itemId}")
    @ApiOperation(value = "根据商品id查询商品标签", notes = "根据商品id查询商品标签 \t\n id：商品id")
    RestResponse<List<TagRespDto>> queryItemTagByItemId(@NotNull(message = "商品id不能为空") @PathVariable("itemId") Long itemId);

}
