/*
 * @(#)Constant.java 1.0 2021年10月08日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.common.enums;

/**
 * <p>Title:Constant</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/8 9:39
 * @since 0.1.0
 */
public interface Constant {


    public enum IsDisable{
        ENABLE("0", "启用"),
        DISABLE("1", "禁用"),
        ;
        private String code;
        private String msg;

        private IsDisable(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public String getCode() {
            return code;
        }

        public String getMsg() {
            return msg;
        }


        public static final String get(String key) {
            IsDisable[] values = IsDisable.values();
            for(IsDisable statusCodeEnum : values) {
                if(statusCodeEnum.code.equals(key)) {
                    return statusCodeEnum.msg;
                }
            }
            return key;
        }
    }

    public enum EffectiveStatus{
        EFFECTIVE("0", "生效中"),
        LOSE("1", "已失效"),
        ;

        private String code;
        private String msg;

        private EffectiveStatus(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public String getCode() {
            return code;
        }

        public String getMsg() {
            return msg;
        }


        public static final String get(String key) {
            EffectiveStatus[] values = EffectiveStatus.values();
            for(EffectiveStatus statusCodeEnum : values) {
                if(statusCodeEnum.code.equals(key)) {
                    return statusCodeEnum.msg;
                }
            }
            return key;
        }
    }
}
