package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ApiModel(value = "ItemShopQueryReqDto", description = "查询店铺商品的dto")
public class ItemShopQueryReqDto extends BaseVo {
    @ApiModelProperty(name = "itemCodes", value = "商品编码")
    private List<String> itemCodes;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    @NotNull(message = "店铺id不能为空")
    private Long shopId;

    @ApiModelProperty(name = "targetType", value = "目标类型，1-客户，2-店铺")
    @NotNull(message = "类型不能为空")
    private Integer targetType;
}
