package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemBundlesReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemBundlesRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 服务接口
*
* @author yiyun
* @since 2021-09-15
*/
@Api(tags = {"商品中心：组合商品服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IRItemBundleQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/bundle",
    url = "${yundt.cube.center.item.api:}"
)
public interface IRItemBundleQueryApi {

    /**
    * 根据id查询
    *
    * @param id id
    * @return   数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询", notes = "根据id查询")
    RestResponse<RItemBundleRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 分页数据
    *
    * @param filter   查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=RItemBundleReqDto")
    RestResponse<PageInfo<RItemBundleRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询组合商品详情
     * @param bundlesReqDto
     * @return
     */
    @PostMapping("/queryBundleItem")
    @ApiOperation(value = "查询组合商品详情", notes = "查询组合商品详情")
    RestResponse<ItemBundlesRespDto> queryBundleItem(@RequestBody ItemBundlesReqDto bundlesReqDto);

    /**
     * 根据商品编码列表查询组合商品集合
     * @param itemCodes 商品编码列表
     * @return
     */
    @PostMapping("/queryBundleItemByCodes")
    @ApiOperation(value = "根据商品编码列表查询组合商品集合", notes = "根据商品编码列表查询组合商品集合")
    RestResponse<List<ItemBundlesRespDto>> queryBundleItemByCodes(@RequestBody List<String> itemCodes);

    /**
     * 组合商品拆分
     * @param itemCode
     * @return
     */
    @GetMapping("/queryBundleItemByItemCode/{itemCode}")
    @ApiOperation(value = "组合商品拆分", notes = "组合商品拆分")
    RestResponse<ItemBundlesRespDto> queryBundleItemByItemCode(@PathVariable("itemCode") String itemCode);

    /**
     * 选择商品-新增组合商品使用
     * @param queryConditionReqDto
     * @return
     */
    @PostMapping("/selectItemPage")
    @ApiOperation(value = "选择商品-新增组合商品使用", notes = "选择商品-新增组合商品使用")
    RestResponse<PageInfo<ItemRespDto>> selectItemPage(@RequestBody ItemQueryConditionReqDto queryConditionReqDto);


    @GetMapping("/itemUse/{itemId}")
    @ApiOperation(value = "查询组合商品是否在商城进行下过订单", notes = "选择商品-查询组合商品是否在商城进行下过订单")
    RestResponse<Void> itemUse(@PathVariable("itemId") Long itemId);


}
