package com.dtyunxi.yundt.cube.center.item.api.base.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemVersionRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(tags = {"商品中心：版本服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-query-IItemVersionQueryApi",
        path = "/v1/item/b2b",
        url = "${yundt.cube.center.item.api:}")
public interface IItemVersionQueryApi {

    /**
     * 根据条件查询商品版本内容
     *
     * @param filter 查询条件
     * @return 版本内容dto
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据条件查询版本内容", notes = "根据条件查询商品版本内容filter=ItemVersionReqDto")
    RestResponse<List<ItemVersionRespDto>> queryItemVersion(@RequestParam("filter") String filter);


    @GetMapping(value = "/{itemId}/snapshot")
    @ApiOperation(value = "根据商品id查询商品快照信息")
    RestResponse<ItemChangeApplyDto> queryItemSnapshotByItemId(@PathVariable("itemId") Long itemId);
}
