package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * SAP物料对象
 */
@Data
@EqualsAndHashCode()
@ApiModel(value = "SapMaterialDto", description = "SAP物料对象")
public class SapMaterialDto  {

    @ApiModelProperty(value = "物料编码")
    @JsonProperty("MATNR")
    @JSONField(name = "MATNR")
    private String matnr;

    @ApiModelProperty(value = "物料类型")
    @JsonProperty("MTART")
    @JSONField(name = "MTART")
    private String mtart;

    @ApiModelProperty(value = "物料描述")
    @JsonProperty("MAKTX")
    @JSONField(name = "MAKTX")
    private String maktx;

    @ApiModelProperty(value = "旧编码")
    @JsonProperty("BISMT")
    @JSONField(name = "BISMT")
    private String bismt;

    @ApiModelProperty(value = "物料组")
    @JsonProperty("MATKL")
    @JSONField(name = "MATKL")
    private String matkl;

    @ApiModelProperty(value = "物料组描述")
    @JsonProperty("WGBEZ")
    @JSONField(name = "WGBEZ")
    private String wgbez;

    @ApiModelProperty(value = "基本计量单位")
    @JsonProperty("MEINS")
    @JSONField(name = "MEINS")
    private String meins;

    @ApiModelProperty(value = "基本计量单位文本")
    @JsonProperty("MSEHL")
    @JSONField(name = "MSEHL")
    private String msehl;

    @ApiModelProperty(value = "物料状态")
    @JsonProperty("MSTAE")
    @JSONField(name = "MSTAE")
    private String mstae;

    @ApiModelProperty(value = "品牌")
    @JsonProperty("ZBRAND")
    @JSONField(name = "ZBRAND")
    private String zBrand;

    @ApiModelProperty(value = "规格/装箱规格(成品)")
    @JsonProperty("BZTXT")
    @JSONField(name = "BZTXT")
    private String bztxt;

    @ApiModelProperty(value = "标签名")
    @JsonProperty("BDTXT")
    @JSONField(name = "BDTXT")
    private String bdtxt;

    @ApiModelProperty(value = "物料初始编码")
    @JsonProperty("ZEINR")
    @JSONField(name = "ZEINR")
    private String zEinr;

    @ApiModelProperty(value = "包材上版本编码")
    @JsonProperty("ZPACKUP")
    @JSONField(name = "ZPACKUP")
    private String zPackUp;

    @ApiModelProperty(value = "别名（注册品名）")
    @JsonProperty("ZALIASNAME")
    @JSONField(name = "ZALIASNAME")
    private String zAliasName;

    @ApiModelProperty(value = "保健功能")
    @JsonProperty("ZEFFCT")
    @JSONField(name = "ZEFFCT")
    private String zEffct;

    @ApiModelProperty(value = "保健功能-描述")
    @JsonProperty("ZEFFCT_D")
    @JSONField(name = "ZEFFCT_D")
    private String zEffctD;

    @ApiModelProperty(value = "品类大类")
    @JsonProperty("ZCATG_MAJ")
    @JSONField(name = "ZCATG_MAJ")
    private String zCatgMaj;

    @ApiModelProperty(value = "品类大类-描述")
    @JsonProperty("ZCATG_MAJ_D")
    @JSONField(name = "ZCATG_MAJ_D")
    private String zCatgMajD;

    @ApiModelProperty(value = "品类中类")
    @JsonProperty("ZCATG_MID")
    @JSONField(name = "ZCATG_MID")
    private String zCatgMid;

    @ApiModelProperty(value = "品类中类-描述")
    @JsonProperty("ZCATG_MID_D")
    @JSONField(name = "ZCATG_MID_D")
    private String zCatgMidD;

    @ApiModelProperty(value = "ABC/XYZ分类")
    @JsonProperty("ZABCXYZ")
    @JSONField(name = "ZABCXYZ")
    private String zAbcxyz;

    @ApiModelProperty(value = "渠道产品分类")
    @JsonProperty("ZCHNL_CAT")
    @JSONField(name = "ZCHNL_CAT")
    private String zChnlCat;

    @ApiModelProperty(value = "渠道产品分类-描述")
    @JsonProperty("ZCHNL_CAT_D")
    @JSONField(name = "ZCHNL_CAT_D")
    private String zChnlCatD;

    @ApiModelProperty(value = "产品类型")
    @JsonProperty("ZPRD_TYPE")
    @JSONField(name = "ZPRD_TYPE")
    private String zPrdType;

    @ApiModelProperty(value = "产品类型-描述")
    @JsonProperty("ZPRD_TYPE_D")
    @JSONField(name = "ZPRD_TYPE_D")
    private String zPrdTypeD;

    @ApiModelProperty(value = "剂型")
    @JsonProperty("ZDOS_FORM")
    @JSONField(name = "ZDOS_FORM")
    private String zDosForm;

    @ApiModelProperty(value = "剂型-描述")
    @JsonProperty("ZDOS_FORM_D")
    @JSONField(name = "ZDOS_FORM_D")
    private String zDosFormD;

    @ApiModelProperty(value = "是否战略品")
    @JsonProperty("ZIF_STRAT")
    @JSONField(name = "ZIF_STRAT")
    private String zIfStrat;

    @ApiModelProperty(value = "成分来源")
    @JsonProperty("ZCOM_SRC")
    @JSONField(name = "ZCOM_SRC")
    private String zComSrc;

    @ApiModelProperty(value = "适宜人群")
    @JsonProperty("ZTGT_GRP")
    @JSONField(name = "ZTGT_GRP")
    private String zTgtGrp;

    @ApiModelProperty(value = "批准文号")
    @JsonProperty("ZAPPR_NO")
    @JSONField(name = "ZAPPR_NO")
    private String zApprNo;

    @ApiModelProperty(value = "是否防伪（名称待定）")
    @JsonProperty("ZSTD_NO")
    @JSONField(name = "ZSTD_NO")
    private String zStdNo;

    @ApiModelProperty(value = "防伪码（4位编码）")
    @JsonProperty("ZSEC_CODE")
    @JSONField(name = "ZSEC_CODE")
    private String zSecCode;

    @ApiModelProperty(value = "条形码（同69码）")
    @JsonProperty("ZBARCODE")
    @JSONField(name = "ZBARCODE")
    private String zBarcode;

    @ApiModelProperty(value = "研发项目编号")
    @JsonProperty("ZPRJ_NO")
    @JSONField(name = "ZPRJ_NO")
    private String zPrjNo;

    @ApiModelProperty(value = "是否串码管理")
    @JsonProperty("ZSER_MGMT")
    @JSONField(name = "ZSER_MGMT")
    private String zSerMgmt;

    @ApiModelProperty(value = "保质期(月)-成品")
    @JsonProperty("ZSHELF_LF")
    @JSONField(name = "ZSHELF_LF")
    private String zShelfLf;

    @ApiModelProperty(value = "综合产量")
    @JsonProperty("ZTOT_YIELD")
    @JSONField(name = "ZTOT_YIELD")
    private String zTotYield;

    @ApiModelProperty(value = "剂型-折算率")
    @JsonProperty("ZDOS_CONV")
    @JSONField(name = "ZDOS_CONV")
    private String zDosConv;

    @ApiModelProperty(value = "剂型-折算单位")
    @JsonProperty("ZDOS_CONVU")
    @JSONField(name = "ZDOS_CONVU")
    private String zDosConvu;

    @ApiModelProperty(value = "是否一次性销售产品")
    @JsonProperty("ZDISPOSABLE")
    @JSONField(name = "ZDISPOSABLE")
    private String zDisposable;

    @ApiModelProperty(value = "最小销售单元长/宽/高")
    @JsonProperty("ZMIN_SIZE")
    @JSONField(name = "ZMIN_SIZE")
    private String zMinSize;

    @ApiModelProperty(value = "最小销售单元规格")
    @JsonProperty("ZMIN_SPEC")
    @JSONField(name = "ZMIN_SPEC")
    private String zMinSpec;

    @ApiModelProperty(value = "最小销售单元装量")
    @JsonProperty("ZMIN_QTY")
    @JSONField(name = "ZMIN_QTY")
    private String zMinQty;

    @ApiModelProperty(value = "最小销售单元体积(m3)")
    @JsonProperty("ZMIN_VOL")
    @JSONField(name = "ZMIN_VOL")
    private BigDecimal zMinVol;

    @ApiModelProperty(value = "最小销售单元毛重(kg)")
    @JsonProperty("ZMIN_WGT")
    @JSONField(name = "ZMIN_WGT")
    private BigDecimal zMinWgt;

    @ApiModelProperty(value = "商品卖点 产品特色")
    @JsonProperty("ZUSP")
    @JSONField(name = "ZUSP")
    private String zUsp;

    @ApiModelProperty(value = "上市时间")
    @JsonProperty("ZLAUNCH_DT")
    @JSONField(name = "ZLAUNCH_DT")
    private String zLaunchDt;

    @ApiModelProperty(value = "退市时间")
    @JsonProperty("ZDISCNT_DT")
    @JSONField(name = "ZDISCNT_DT")
    private String zDiscntDt;

    @ApiModelProperty(value = "生产商")
    @JsonProperty("ZMAN_SUP")
    @JSONField(name = "ZMAN_SUP")
    private String zMansup;

    @ApiModelProperty(value = "产品其他备注")
    @JsonProperty("ZOTHER")
    @JSONField(name = "ZOTHER")
    private String zOther;

    @ApiModelProperty(value = "长度(cm）-大包包装规格")
    @JsonProperty("ZPKG_LG_B")
    @JSONField(name = "ZPKG_LG_B")
    private BigDecimal zPkgLgB;

    @ApiModelProperty(value = "宽度(cm）-大包包装规格")
    @JsonProperty("ZPKG_WD_B")
    @JSONField(name = "ZPKG_WD_B")
    private BigDecimal zPkgWdB;

    @ApiModelProperty(value = "高度(cm）-大包包装规格")
    @JsonProperty("ZPKG_HG_B")
    @JSONField(name = "ZPKG_HG_B")
    private BigDecimal zPkgHgB;

    @ApiModelProperty(value = "体积(m3)-大包体积")
    @JsonProperty("ZPKG_VOL_B")
    @JSONField(name = "ZPKG_VOL_B")
    private String zPkgVolB;

    @ApiModelProperty(value = "重量规格(kg)-大包重量")
    @JsonProperty("ZPKG_WT_B")
    @JSONField(name = "ZPKG_WT_B")
    private String zPkgWtB;

    @ApiModelProperty(value = "装箱数")
    @JsonProperty("ZPKG_QTY")
    @JSONField(name = "ZPKG_QTY")
    private String zPkgQty;

    @ApiModelProperty(value = "大包比例")
    @JsonProperty("ZPKG_RT_B")
    @JSONField(name = "ZPKG_RT_B")
    private Long zPkgRtB;

    @ApiModelProperty(value = "中包比例")
    @JsonProperty("ZPKG_RT_M")
    @JSONField(name = "ZPKG_RT_M")
    private Long zPkgRtM;

    @ApiModelProperty(value = "箱托比例")
    @JsonProperty("ZPKG_RT_P")
    @JSONField(name = "ZPKG_RT_P")
    private Long zPkgRtP;

    @ApiModelProperty(value = "拖车比例")
    @JsonProperty("ZPKG_RT_T")
    @JSONField(name = "ZPKG_RT_T")
    private String zPkgRtT;

    @ApiModelProperty(value = "中包包装规格")
    @JsonProperty("ZPKG_SPC_M")
    @JSONField(name = "ZPKG_SPC_M")
    private String zPkgSpcM;

    @ApiModelProperty(value = "大箱包装规格")
    @JsonProperty("ZPKG_SPC_C")
    @JSONField(name = "ZPKG_SPC_C")
    private String zPkgSpcC;

    @ApiModelProperty(value = "是否可脱包装")
    @JsonProperty("ZPKG_REMV")
    @JSONField(name = "ZPKG_REMV")
    private String zPkgRemv;

    @ApiModelProperty(value = "原料/辅料")
    @JsonProperty("ZRAW_MAT")
    @JSONField(name = "ZRAW_MAT")
    private String zRawMat;

    @ApiModelProperty(value = "材质")
    @JsonProperty("ZMATE_TYPE")
    @JSONField(name = "ZMATE_TYPE")
    private String zMateType;

    @ApiModelProperty(value = "是否允许混批存放")
    @JsonProperty("ZBATCH_MIX")
    @JSONField(name = "ZBATCH_MIX")
    private String zBatchMix;

    @ApiModelProperty(value = "包材细分类")
    @JsonProperty("ZPCK_CAT")
    @JSONField(name = "ZPCK_CAT")
    private String zPckCat;

    @ApiModelProperty(value = "创建时间")
    @JsonProperty("ERSDA")
    @JSONField(name = "ERSDA")
    private String ersda;

    @ApiModelProperty(value = "更新时间")
    @JsonProperty("LAEDA")
    @JSONField(name = "LAEDA")
    private String laeda;
}