package com.dtyunxi.yundt.cube.center.item.api.b2b;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.BatchOptProhibiteSaleItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 客户禁售商品表服务接口
 *
 * @author cijian
 * @since 2022-11-15
 */
@Api(tags = {"客户禁售商品表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-item-api-api-IProhibiteSaleItemApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/prohibiteSaleItem",
        url = "${yundt.cube.center.item.api:}"
)
public interface IProhibiteSaleItemApi {

//    /**
//     * 新增客户禁售商品表
//     *
//     * @param addReqDto 客户禁售商品表请求对象
//     * @return 处理结果
//     */
//    @PostMapping("")
//    @ApiOperation(value = "新增客户禁售商品表", notes = "新增客户禁售商品表")
//    RestResponse<Long> addProhibiteSaleItem(@RequestBody ProhibiteSaleItemReqDto addReqDto);

    /**
     * 批量禁售/启售商品
     *
     * @param batchOptProhibiteSaleItemReqDto 客户禁售商品表请求集合
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增客户禁售商品表", notes = "新增客户禁售商品表")
    RestResponse<Void> batchOptProhibiteSaleItem(@RequestBody BatchOptProhibiteSaleItemReqDto batchOptProhibiteSaleItemReqDto);
}
