/**
 * @(#) ItemTaskStatus.java 1.0 2019-03-01
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 商品定时上下架状态描述枚举
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum ShelfTaskStatusEnum {
    UNPROCESSED(0, "未处理"),
    PROCESSING(1, "处理中"),
    SUCCESS(2, "处理成功"),
    FAIL(3, "处理失败"),
    CANCEL(4, "取消处理"),
    ;

    private Integer status;
    private String desc;

    ShelfTaskStatusEnum(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
