/**
 * @(#) IExampleQueryApi.java 1.1.0 2018-06-13
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 品牌查询接口
 *
 * @author 风影
 * @since 2.0.0
 */
@Api(tags = {"商品中心：品牌查询服务接口"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IBrandQueryApi",
        path = "/v1/brand",
        url = "${yundt.cube.center.item.api:}")
public interface IBrandQueryApi {

    /**
     * 根据ID主键查询
     *
     * @param id 主键
     * @return RestResponse<BrandReqDto>
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "根据Id查询品牌信息", notes = "根据Id查询品牌信息 \t\n id:品牌Id")
    RestResponse<BrandRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页查询品牌列表 filter -> BrandReqDto
     *
     * @param filter   查询参数brandDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return RestResponse<PageInfoRequestBrandDto>>
     */
    @GetMapping(value = "/list")
    @ApiOperation(value = "分页查询品牌分页列表", notes = "根据pageNum,pageSize,品牌Dto查询品牌信息,filter=BrandReqDto")
    RestResponse<PageInfo<BrandRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                     @RequestParam(name = "pageNum", required = false, defaultValue =
                                                             "1") Integer pageNum,
                                                     @RequestParam(name = "pageSize", required = false, defaultValue
                                                             = "10") Integer pageSize);



    /**
     * 根据品牌id列表批量查询品牌
     *
     * @param brandIds 品牌id列表
     * @return 品牌列表
     * @author wu.sheng
     * @date 2019/11/25 14:37
     */
    @GetMapping(value = "/ids")
    @ApiOperation(value = "根据品牌id列表批量查询品牌", notes="批量查询，多个逗号隔开")
    RestResponse<List<BrandRespDto>> queryByIds(@RequestParam("brandIds") String brandIds);


    @GetMapping(value = "/code/{code}")
    @ApiOperation(value = "根据Id查询品牌信息", notes = "根据Id查询品牌信息 \t\n id:品牌Id")
    RestResponse<BrandRespDto> queryCode(@PathVariable("code") String code);
}
