package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.*;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemExtListInfo;
import com.dtyunxi.yundt.cube.center.item.api.dto.OrderInfoExportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * 商品|产品定义服务接口
 *
 * @author yiyun
 * @since 2021-08-18
 */
@Api(tags = {"商品中心：商品定义扩展服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemExtQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtQueryApi {

    /**
     * 根据itemId批量查询商品信息
     * @param itemIds
     * @return
     */
    @PostMapping("/extend/item/queryByIds")
    @ApiOperation(
            value = "根据itemId批量查询商品信息",
            notes = "根据itemId批量查询商品信息"
    )
    RestResponse<List<ItemRespDto>> queryByIds(@RequestParam List<Long> itemIds);

    /**
     * 根据sku编码查询sku信息
     * @param skuIds
     * @return
     */
    @PostMapping({"/extend/itemqueryBySkuId"})
    @ApiOperation(value = "根据sku编码查询sku信息",notes = "根据sku编码查询sku信息")
    RestResponse<List<ItemSkuRespDto>> queryBySkuId(@RequestBody List<Long> skuIds);

    /**
     * 根据sku编码查询sku信息
     * @param skuCodeList sku编码集合
     * @return
     */
    @PostMapping({"/extend/itemqueryBySkuCodeList"})
    @ApiOperation(value = "根据sku编码集合查询sku信息",notes = "根据sku编码集合查询sku信息")
    RestResponse<List<ItemSkuRespDto>> queryBySkuCodeList(@RequestBody List<String> skuCodeList);


    /**
     * 根据sku编码查询sku信息
     * @param skuCodeList sku编码集合
     * @return
     */
    @PostMapping({"/extend/itemqueryBySkuCodes"})
    @ApiOperation(value = "根据sku编码集合查询sku信息",notes = "根据sku编码集合查询sku信息")
    RestResponse<List<ItemSkuRespExtDto>> queryBySkuCodes(@RequestBody List<String> skuCodeList);



    @PostMapping("/extend/item/queryItemShelf")
    @ApiOperation(
            value = "查询商品上架信息",
            notes = "查询商品上架信息 \t\n ,filter=ShelfReqDto"
    )
    RestResponse<ItemShelfRespDto> queryItemShelf(@RequestParam("skuId") Long skuId,
                                                  @RequestParam("shopId") Long shopId,
                                                  @RequestParam("shelfAddress") String shelfAddress);


    @GetMapping({"/extend/item/list"})
    @ApiOperation(
            value = "分页查询商品列表",
            notes = "分页查询商品列表，filter=itemQueryConditionReqDto"
    )
    RestResponse<PageInfo<ItemRespDto>> queryItemsByPage(@ModelAttribute ItemQueryConditionReqDto itemQueryConditionReqDto,
                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
    @PostMapping({"/extend/item/queryByPage"})
    @ApiOperation(
            value = "分页查询商品列表",
            notes = "分页查询商品列表，filter=itemQueryConditionReqDto"
    )
    RestResponse<PageInfo<ItemRespDto>> queryByPage(@RequestBody ItemQueryConditionReqDto itemQueryConditionReqDto,
                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping("/extend/item/querySkuByCode/{code}")
    @ApiOperation(
            value = "根据skuCode查询sku信息",
            notes = "根据skuCode查询sku信息"
    )
    RestResponse<ItemSkuRespDto> querySkuByCode(@PathVariable("code") String code);

    @PostMapping("/extend/item/external")
    @ApiOperation(
            value = "分页查询商品列表-外部系统使用（如：用户服务系统）",
            notes = "分页查询商品列表-外部系统使用（如：用户服务系统）"
    )
    RestResponse<PageInfo<ItemRespDto>> externalByPage(@RequestBody(required = false) ItemExternalReqDto reqDto);

    /**
     * 根据skuCode查询商品列表
     *
     * @param skuCode
     * @return
     */
    @GetMapping({"/extend/item/queryItemBySkuCode/{skuCode}"})
    @ApiOperation(
            value = "根据skuCodes查询商品列表",
            notes = "根据skuCodes查询商品列表"
    )
    RestResponse<PageInfo<ItemRespDto>> queryItemBySkuCode(@NotNull @PathVariable("skuCode") String skuCode,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据skuCodes精确查询商品列表
     *
     * @param skuCodes
     * @return
     */
    @GetMapping({"/extend/item/exectQueryBySkuCode/{skuCodes}"})
    @ApiOperation(
            value = "根据skuCodes精确查询商品列表",
            notes = "根据skuCodes精确查询商品列表,skuCodes支持传复数"
    )
    RestResponse<List<ItemRespDto>> exectQueryBySkuCode(@NotNull @PathVariable("skuCodes") List<String> skuCodes);

    /**
     * 根据id查询商品|产品定义
     *
     * @param id 商品|产品定义id
     * @return 商品|产品定义数据
     */
    @GetMapping("/extend/item/{id}")
    @ApiOperation(value = "根据id查询商品|产品定义", notes = "根据id查询商品|产品定义")
    RestResponse<ItemTradeRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页查询上架商品列表
     *
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/extend/item/queryShelfPage")
    @ApiOperation(value = "分页查询上架商品列表", notes = "分页查询上架商品列表")
    RestResponse<ItemShelfListRespDto> queryShelfPage(@ModelAttribute ItemShelfQueryReqDto queryReqDto,
                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据itemId查询商品详情
     *
     * @param itemId
     * @return
     */
    @GetMapping("/extend/item/getItemDetail/{itemId}")
    @ApiOperation(value = "查询商品详情", notes = "查询商品详情")
    RestResponse<BdItemDetailRespDto> getItemDetail(@PathVariable("itemId") Long itemId);

    /**
     * Hd根据itemId查询商品详情
     *
     * @param itemId
     * @return
     */
    @GetMapping("/extend/item/hdQueryItemDetail/{itemId}")
    @ApiOperation(value = "hd查询商品详情", notes = "hd查询商品详情")
    RestResponse<ItemDetailHdRespDto> hdQueryItemDetail(@PathVariable("itemId") Long itemId);

    /**
     * 根据商品id批量查询商品信息
     * @param itemIds
     * @return
     */
    @PostMapping("/extend/item/queryItemDetails")
    @ApiOperation(value = "查询商品详情", notes = "查询商品详情")
    RestResponse<List<ItemRespDto>> queryItemDetails(@RequestBody List<Long> itemIds);

    /**
     * 未上架商品列表
     *
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/extend/item/notOnShelfItemPage")
    @ApiOperation(value = "未上架商品列表", notes = "未上架商品列表")
    RestResponse<PageInfo<ShelfListRespDto>> notOnShelfItemPage(@ModelAttribute ItemShelfQueryReqDto queryReqDto,
                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据商品编码查询商品信息
     *
     * @param code
     * @return
     */
    @GetMapping(value = "/extend/item/getItemList/{code}")
    @ApiOperation(value = "根据商品编码查询商品信息", notes = "根据商品编码查询商品信息")
    RestResponse<List<ItemExtListInfo>> getItemList(@PathVariable("code") String code);


    /**
     * 根据商品Id或编码查询商品信息
     *
     * @param reqDto
     * @return
     */
    @PostMapping("/extend/item/queryItem")
    @ApiOperation(value = "根据商品Id或编码查询商品信息", notes = "根据商品Id或编码查询商品信息")
    RestResponse<List<ItemExtListRespDto>> queryItem(@RequestBody ItemExtListReqDto reqDto);

    /**
     * 查询商品SKU信息
     *
     * @param itemId
     * @return
     */
    @GetMapping("/extend/item/queryItemSkuByItemId/{itemId}")
    @ApiOperation(value = "查询商品SKU信息", notes = "查询商品SKU信息")
    RestResponse<List<ItemSkuRespDto>> queryItemSkuByItemId(@PathVariable("itemId") Long itemId);

    /**
     * 商品列表数据
     *
     * @param itemPageReqDto
     * @return
     */
    @GetMapping({"/extend/item/item/list"})
    @ApiOperation(
            value = "商品列表数据",
            notes = "商品列表数据"
    )
    RestResponse<List<ItemListRespDto>> queryItemList(@ModelAttribute ItemPageReqDto itemPageReqDto);

    /**
     * 根据skuCodes查询商品列表
     *
     * @param skuCodes
     * @return
     */
    //@GetMapping({"/list/{skuCodes}/{channelCode}"})
    @PostMapping("/extend/item/list")
    @ApiOperation(
            value = "根据skuCodes查询商品列表",
            notes = "根据skuCodes查询商品列表,skuCodes支持传复数"
    )
    RestResponse<List<ItemListInfoRespDto>> queryItems(@RequestBody List<String> skuCodes,
                                                       @RequestParam("shopCode") String shopCode,
                                                       @RequestParam("channelCode") String channelCode);


    /**
     * 查询商品映射数据（订单中心需求新接口）
     * @param channelItemCodes
     * @param shopCode
     * @param channelCode
     * @return
     */
    @PostMapping("/extend/item/queryItemMapping")
    @ApiOperation(value = "查询商品映射数据",notes = "查询商品映射数据")
    RestResponse<List<ItemListInfoRespDto>> queryItemMapping(@RequestBody List<String> channelItemCodes,
                                                             @RequestParam("shopCode") String shopCode,
                                                             @RequestParam("channelCode") String channelCode);

    /**
     * 商品数据拆分（存在组合商品时，则拆分商品）(提供给订单中心新接口)
     * @param channelItemCodes
     * @return
     */
    @PostMapping("/extend/item/queryItemSplit")
    @ApiOperation(value = "商品数据拆分（存在组合商品时，则拆分商品）",notes = "商品数据拆分（存在组合商品时，则拆分商品）")
    RestResponse<ItemSplitRespDto> queryItemSplit(@RequestBody List<String> channelItemCodes);


    /**
     * 根据商品编码查询中台商品信息(如果为组合商品，则拆分组合商品)
     * @param itemCodes
     * @return
     */
    @PostMapping(value = "/extend/item/getMiddleItemListByItemCode")
    RestResponse<List<ItemListInfoRespDto>> getMiddleItemListByItemCode(@RequestBody List<String> itemCodes);

    @PostMapping(value = "/extend/item/getItemListSimpleByItemCode")
    RestResponse<List<ItemListInfoRespDto>> getItemListSimpleByItemCode(@RequestBody List<String> itemCodes);

    /**
     * 根据ID查询商城商品详情
     *
     * @param itemId
     * @return
     */
    @GetMapping({"/extend/item/item/detail"})
    @ApiOperation(
            value = "商品详情",
            notes = "商品详情"
    )
    RestResponse<ItemExtDetailRespDto> queryItemDetailById(@RequestParam(value = "itemId") Long itemId,
                                                           @RequestParam(value = "customerId", required = false) Long customerId,
                                                           @RequestParam(value = "shelfAddress", required = false) String shelfAddress);

    /**
     * 查询商城商品列表
     *
     * @param itemQueryConditionReqDto
     * @return
     */
    @GetMapping({"/extend/item/queryTradeItem"})
    @ApiOperation(
            value = "分页查询商品列表",
            notes = "分页查询商品列表，filter=itemQueryConditionReqDto"
    )
    RestResponse<PageInfo<ItemTradeInfoRespDto>> queryTradeItem(@ModelAttribute ItemQueryConditionReqDto itemQueryConditionReqDto);

    /**
     * 分页查询普通商品列表
     *
     * @param itemQueryConditionReqDto
     * @return
     */
    @PostMapping("/extend/item/queryItemPage")
    @ApiOperation(value = "分页查询普通商品列表", notes = "分页查询普通商品列表，filter=ItemQueryConditionReqDto")
    RestResponse<PageInfo<ItemRespDto>> queryItemPage(@RequestBody ItemRelationConditionReqDto itemQueryConditionReqDto);


    /**
     * 分页查询商品列表-商城推荐商品使用(已上架的商品)
     *
     * @param itemQueryConditionReqDto
     * @return
     */
    @PostMapping("/extend/item/trade/item/shopping")
    @ApiOperation(value = "分页查询商品列表-商城推荐商品使用", notes = "分页查询商品列表-商城推荐商品使用(已上架的商品)，filter=ItemQueryConditionReqDto")
    RestResponse<PageInfo<ItemRespDto>> queryItemTradeShopping(@RequestBody ItemQueryConditionReqDto itemQueryConditionReqDto);

    /**
     * 根据时间降序取第一条数据,(排除组合商品)
     *
     * @return
     */
    @GetMapping("/extend/item/getItemCreateTime")
    @ApiOperation(value = "根据时间降序取第一条数据,(排除组合商品)", notes = "根据时间降序取第一条数据,(排除组合商品)")
    RestResponse<String> getItemCreateTime();

    /**
     * 根据商品Id和类型查询主图
     *
     * @param itemId
     * @return
     */
    @GetMapping("/extend/item/queryMediasByItemId/{itemId}")
    @ApiOperation(value = "根据商品Id和类型查询主图", notes = "根据商品Id和类型查询主图")
    RestResponse<List<ItemMediasRespDto>> queryMediasByItemId(@PathVariable("itemId") Long itemId);

    /**
     * 批量根据商品Id和类型查询主图
     *
     * @param itemIds
     * @param fileType
     * @return
     */
    @GetMapping("/extend/item/queryMedias/{itemIds}/{fileType}")
    @ApiOperation(value = "批量根据商品Id和类型查询主图", notes = "根据商品Id和类型查询主图")
    RestResponse<List<ItemMediasRespDto>> queryMedias(@PathVariable("itemIds") List<Long> itemIds, @PathVariable("fileType") Integer fileType);

    @GetMapping({"/extend/item/dir/{dirIds}"})
    @ApiOperation(
            value = "通过目录id查询商品列表(get接口方式)",
            notes = "通过目录id查询商品列表(get接口方式) \tu\n id:目录id，filter=RequestDto"
    )
    RestResponse<List<ItemRespDto>> queryItemByDirIds(@PathVariable("dirIds") String dirIds);

    @PostMapping({"/extend/item/dir/post"})
    @ApiOperation(
            value = "通过目录id查询商品列表(post接口方式)",
            notes = "通过目录id查询商品列表(post接口方式) \tu\n id:目录id，filter=RequestDto"
    )
    RestResponse<List<ItemRespDto>> queryItemByDirIdsWithPost(@RequestBody String dirIds);

    /**
     * 分页查询
     *
     * @param queryReqDto
     * @return
     */
    @PostMapping("/extend/item/query/keywords")
    @ApiOperation(value = "分页查询商品列表-商城搜索列表使用", notes = "分页查询商品列表-商城搜索列表使用")
    RestResponse<PageInfo<ShelfListRespDto>> queryItemByKeywords(@RequestBody ItemShelfQueryReqDto queryReqDto,
                                                                 @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    @PostMapping({"/extend/item/detail/branch"})
    @ApiOperation(
            value = "批量查询商品信息（性能优化订单专用接口，其他勿用）",
            notes = "批量查询商品信息（性能优化订单专用接口，其他勿用）"
    )
    RestResponse<BranchItemRespDto> branchQueryItem(@RequestBody BranchQueryItemReqDto branchQueryItemReq);

    /**
     * 根据itemIds查询虚拟库存
     *
     * @param itemIds
     * @return
     */
    @PostMapping({"/extend/item/queryItemStorageByItemIds"})
    @ApiOperation(
            value = "根据itemIds查询虚拟库存",
            notes = "根据itemIds查询虚拟库存"
    )
    RestResponse<List<ItemStorageRespDto>> queryItemStorageByItemIds(@NotNull @RequestParam("itemIds") List<Long> itemIds);


    /**
     * 组合商品
     *
     * @param itemCodes
     * @return
     */
    @PostMapping({"/extend/item/combination/item"})
    @ApiOperation(
            value = "组合商品子商品编码",
            notes = "组合商品子商品编码"
    )
    RestResponse<List<CombinationItemRespDto>> queryCombinationItem(@RequestBody List<String> itemCodes);

    /**
     * 解析导入excel
     *
     * @param url
     * @return
     */
    @GetMapping({"/extend/item/analysis/data"})
    @ApiOperation(
            value = "解析导入excel",
            notes = "解析导入excel"
    )
    RestResponse<List<OrderInfoExportDto>> analysisExcelData(@RequestParam(value = "url") String url);


    /**
     * 爆款商品查询
     * @return
     */
    @PostMapping("/extend/item/getPopularItem")
    @ApiOperation(value = "爆款商品查询", notes = "爆款商品查询")
    RestResponse<List<OrderItemPopularRespDto>> getPopularItem(@RequestBody ItemEffectiveReqDto itemEffectiveReqDto);

    @GetMapping({"/extend/item/getBuydeemItemDetailByCode/{itemCode}"})
    @ApiOperation(
            value = "查询北鼎商品详情",
            notes = "查询北鼎商品详情"
    )
    RestResponse<BuydeemItemDetailRespDto> getBuydeemItemDetailByItemCode(@PathVariable("itemCode") String itemCode);

    @GetMapping({"/extend/item/batchQuerBuydeemItemDetail/{size}"})
    @ApiOperation(
            value = "批量接口拉取北鼎官网商品详情",
            notes = "批量接口拉取北鼎官网商品详情"
    )
    RestResponse<List<BuydeemItemDetailRespDto>> batchQuerBuydeemItemDetail(@PathVariable("size") Integer size);

    /**
     * 批量查询商品图片
     * @param itemIds
     * @return
     */
    @PostMapping("/extend/item/batchQueryItemMedias")
    @ApiOperation(value = "批量查询商品图片", notes = "批量查询商品图片")
    RestResponse<List<ItemMediasRespDto>> batchQueryItemMedias(@RequestBody List<Long> itemIds);

    /**
     * 根据商品编码批量查询商品图片
     * @param itemCodes
     * @return
     */
    @PostMapping("/extend/item/batchQueryItemImage")
    @ApiOperation(value = "根据商品编码批量查询商品图片", notes = "根据商品编码批量查询商品图片")
    RestResponse<List<ItemMediasRespDto>> batchQueryItemImage(@RequestBody List<String> itemCodes);

    /**
     * 根据商品编码批量查询商品图片
     * @param itemCodes
     * @return
     */
    @PostMapping("/extend/item/queryItemImageList")
    @ApiOperation(value = "根据商品编码批量查询商品图片", notes = "根据商品编码批量查询商品图片")
    RestResponse<List<Map<String,ItemMediasRespDto>>> queryItemImageList(@RequestBody List<String> itemCodes);

    /**
     * 根据编码批量查询商品数据
     * @param itemCodes
     * @return
     */
    @PostMapping("/extend/item/batchQueryItem")
    @ApiOperation(value = "根据编码批量查询商品数据", notes = "根据编码批量查询商品数据")
    RestResponse<List<ItemRespDto>> batchQueryItem(@RequestBody List<String> itemCodes);


    /**
     * 批量查询上架商品信息（b2b商城下单使用）
     * @param skuIds
     * @param shopId
     * @param shelfAddress
     * @return
     */
    @PostMapping("/extend/item/batchQueryShelfItem")
    @ApiOperation(value = "批量查询上架商品信息（b2b商城下单使用）", notes = "批量查询上架商品信息（b2b商城下单使用）")
    RestResponse<List<ItemRespDto>> batchQueryShelfItem(@RequestBody List<Long> skuIds,
                                                        @RequestParam("shopId") Long shopId,
                                                        @RequestParam("shelfAddress") String shelfAddress);

    /**
     * 根据itemId批量查询Sku商品信息
     * @param itemIds
     * @return
     */
    @PostMapping("/extend/item/queryByItemIds")
    @ApiOperation(value = "根据itemId批量查询Sku商品信息",notes = "根据itemId批量查询Sku商品信息")
    RestResponse<List<ItemSkuRespDto>> queryByItemIds(@RequestBody List<Long> itemIds);

    /**
     * 查询所有商品编码
     * @return
     */
    @PostMapping("/extend/item/getItemCodes")
    @ApiOperation(value = "查询所有商品编码",notes = "查询所有商品编码")
    RestResponse<List<String>> getItemCodes();

    @PostMapping({"/extend/item/queryItemControlByPage"})
    @ApiOperation(
            value = "分页查询商品列表",
            notes = "分页查询商品列表，filter=itemQueryConditionReqDto"
    )
    RestResponse<PageInfo<ItemRespDto>> queryItemControlByPage(@RequestBody(required = false) ItemQueryConditionReqDto itemQueryConditionReqDto,
                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    @PostMapping("/extend/item/getItemCodesByControlStatus")
    @ApiOperation(value = "查询商品编码列表(商品管控状态：YES：管控；NO：非管控)",notes = "查询商品编码列表(商品管控状态：YES：管控；NO：非管控)")
    RestResponse<List<String>> getItemCodesByControlStatus(@RequestParam(name = "itemControlStatus", defaultValue = "YES") String itemControlStatus);

    /**
     * post分页查询上架商品列表
     * @param queryReqDto
     * @return
     */
    @PostMapping("/extend/item/query/shelfPage")
    @ApiOperation(value = "分页查询上架商品列表", notes = "分页查询上架商品列表")
    RestResponse<ItemShelfListRespDto> queryShelfPage(@RequestBody ItemShelfQueryReqDto queryReqDto);


    /**
     * 查询所有商品信息
     * @return
     */
    @PostMapping("/extend/item/queryAllItems")
    @ApiOperation(value = "批量查询商品数据", notes = "批量查询商品数据")
    RestResponse<List<ItemRespDto>> queryAllItems();

    @PostMapping("/item/ext/queryByCodes")
    @ApiOperation(value = "根据商品编号集合查询商品信息", notes = "根据商品编号集合查询商品信息")
    RestResponse<List<ItemRespDto>> queryByCodes(@RequestBody List<String> codes);

    /**
     * 查询商品上架列表
     *
     * @return 返回分页ItemShelfRespDto列表
     */
    @PostMapping(value = "/item/ext/shelf/list")
    @ApiOperation(value = "查询商品上架列表", notes = "查询商品上架列表")
    RestResponse<List<ItemShelfRespDto>> queryItemShelf(@RequestBody ShelfExtReqDto shelfExtReqDto);

    /**
     * 根据商品ID查询商品详情
     *
     * @return 返回ItemDetailDto列表
     */
    @PostMapping(value = "/item/ext/queryItemDetailByItemIds")
    @ApiOperation(value = "根据商品ID查询商品详情", notes = "根据商品ID查询商品详情,\nfield 显示项：sku,attributes,medias,task表示查询SKU,商品属性,多媒体,定时任务。\ndirId传值表明查询该目录的上架数据，不传则查询商品ID的对应的上架数据。")
    RestResponse<List<ItemDetailRespDto>> queryItemDetailByItemIds(@RequestBody ItemDetailBatchReqDto itemDetailBatchReqDto);


    /**
     * 根据商品上架表得到的商品ID等查询商品外部系统编码
     * @author lsw
     * @return 返回商品授权表的extractCode
     */
    @PostMapping(value = "/item/ext/queryExaractCodeByShelf")
    @ApiOperation(value = "根据商品上架表ID等查询商品外部系统编码", notes = "根据商品上架表得到的商品ID等查询商品外部系统编码")
    RestResponse<List<ItemAuthExtractCodeRespDto>> queryExaractCodeByShelf(@RequestBody ItemAuthExtractCodeReqDto reqDto);

    @PostMapping({"/item/ext/pageByPost"})
    @ApiOperation(
            value = "分页查询上架商品列表",
            notes = "分页查询上架商品列表",
            response = ItemShelfQueryRespDto.class
    )
    RestResponse<PageInfo<ItemShelfQueryRespDto>> queryShelfItemByPageByPost(@RequestBody ItemShelfQueryExtReqDto itemShelfQueryReqDto, @RequestParam(name = "pageNum",required = false,defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize);
}
