package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemShopPlatformRelationReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 商品与店铺平台关系表服务接口
*
* @author yiyun
* @since 2021-09-18
*/
@Api(tags = {"商品中心：商品与店铺平台关系表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemShopPlatformRelationApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/shop/platform/relation",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemShopPlatformRelationApi {

/**
* 新增商品与店铺平台关系表
*
* @param addReqDto 商品与店铺平台关系表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增商品与店铺平台关系表", notes = "新增商品与店铺平台关系表")
RestResponse<Long> addItemShopPlatformRelation(@RequestBody ItemShopPlatformRelationReqDto addReqDto);

    /**
    * 修改商品与店铺平台关系表
    *
    * @param modifyReqDto 商品与店铺平台关系表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品与店铺平台关系表", notes = "修改商品与店铺平台关系表")
    RestResponse<Void> modifyItemShopPlatformRelation(@RequestBody ItemShopPlatformRelationReqDto modifyReqDto);

    /**
    * 删除商品与店铺平台关系表
    *
    * @param ids        商品与店铺平台关系表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品与店铺平台关系表", notes = "删除商品与店铺平台关系表")
    RestResponse<Void> removeItemShopPlatformRelation(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
