/*
 * @(#)ItemConstant.java 1.0 2021年08月24日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.common.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * <p>Title:ItemConstant</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/8/24 14:47
 * @since 0.1.0
 */
public class ItemConstant {

    public static final String COMMON = "common";

    /**
     * 默认店铺id
     */
    public static final Long SHOP_ID = 1280603623604356097L;

    /**
     * 默认卖家id
     */
    public static final Long SELLER_ID = 1228767178875440149L;

    /**
     * 价格类型
     */
    public static final String PRICE_TYPE = "RETAIL_PRICE";

    /**
     * 价格类型
     */
    public static final String ITEM_CODE = "itemCode";

    /**
     * 删除标识已删除
     */
    public static final Integer DR = 1;

    /**
     * 删除标识未删除
     */
    public static final Integer NO_DR = 1;

    public static final String BRACE = "{}";

    public static final String FRONT_USAGE = "front";
    public static final String BACK_USAGE = "back";
    /**
     * 选择商品库时，使用，判断过滤已上架的商品
     */
    public static final String FORWARD = "add";
    /**
     * 新增推荐商品时使用
     */
    public static final String STATISTICS = "statistics";
    public static final String EXPENSES = "expenses";
    public static final String PROMOTE = "promote";
    public static final String PLANTFORM = "plantform";
    //OMS查询可选商品
    public static final String PLANTFORM_OMS = "oms";
    //是否包含组合商品0不包含、1包含
    public static final String INCLUDE_GROUP_FLAG_YES = "1";


    public static final List<String> SHELF_ADDRESS = Lists.newArrayList("0","1");

    /**
     * 组合商品编码前缀
     */
    public static final String ZH_ITEM_CODE_PREFIX = "ZH";

    /**
     * 查询普通商品与赠品标识
     */
    public static final String TYPE_FLAG = "list";
    /**
     * mgmt查询组合商品列表
     */
    public static final String TYPE_BUNDLE_FLAG = "bundle";

    /**
     * 目录缓存group
     */
    public static final String ITEM_DIR_CACHE_GROUP = "item_";

    /**
     * 商品信息缓存group
     */
    public static final String ITEM_TRADE_CACHE_GROUP = "item_trade_";
    public static final String ITEM_STORAGE_CACHE_GROUP = "item_storage_";

    /**
     * 允销信息缓存group
     */
    public static final String ITEM_EMPOWER_CACHE_GROUP = "empower_item_";
    /**
     * 目录缓存group
     */
    public static final String IMPORT_ITEM_PLATFORM_SUCCESS = "商品允销平台关系导入成功！";

    public static final String ERROR_EMPOWER_NULL_PLATFORM= "该客户没有允销平台,商品无法允销！";

    public static final Integer TITLEROWS = 3;

    /**
     * 置顶操作
     */
    public static final String ITEM_TOP = "1";

    /**
     * 已使用
     */
    public static final Integer ITEM_USE = 1;

    public static final String GET_TOKEN_STATE = "2000";


}
