package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"商品中心：商品库存接口扩展服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemStorageQueryExtApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/storage/ext",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemStorageQueryExtApi {

    @PostMapping({"/list"})
    @ApiOperation(
            value = "消费端:查询店铺下skuId可用的货品库存",
            notes = "消费端:查询店铺下skuId可用的货品库存(filter支持单数或复数查询filter={...} or filter=[{...},{...}])，filter=ItemStorageQueryReqDto(支持集合)"
    )
    RestResponse<List<ItemStorageQueryRespDto>> queryItemStorage(@RequestBody ItemStorageQueryReqDto itemStorageQueryReqDto);
}
