package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemChannelReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemChannelRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商品授权渠道关系表服务接口
 *
 * @author yiyun
 * @since 2021-08-18
 */
@Api(tags = {"商品中心：商品授权渠道关系表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemChannelQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/channel",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemChannelQueryApi {

    /**
     * 根据id查询商品授权渠道关系表
     *
     * @param id 商品授权渠道关系表id
     * @return 商品授权渠道关系表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品授权渠道关系表", notes = "根据id查询商品授权渠道关系表")
    RestResponse<ItemChannelRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 商品授权渠道关系表分页数据
     *
     * @param filter   商品授权渠道关系表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 商品授权渠道关系表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "商品授权渠道关系表分页数据", notes = "根据filter查询条件查询商品授权渠道关系表数据，filter=ItemChannelReqDto")
    RestResponse<PageInfo<ItemChannelRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据商品编码查询授权平台关系数据
     * @param reqDto
     * @return
     */
    @PostMapping("/getChannelPlatform")
    @ApiOperation(value = "根据商品ID查询授权平台关系数据", notes = "根据商品ID查询授权平台关系数据")
    RestResponse<List<ItemChannelRespDto>> getChannelPlatform(@RequestBody ItemChannelReqDto reqDto);

    /**
     * 根据商品id集合查询授权平台关系数据信息
     *
     * @param itemIds
     * @return
     */
    @GetMapping("/queryListByItemIds")
    @ApiOperation(value = "根据商品id集合查询授权平台关系数据信息", notes = "根据商品id集合查询授权平台关系数据信息")
    RestResponse<List<ItemChannelRespDto>> queryListByItemIds(@RequestParam("itemIds") List<Long> itemIds);

    /**
     * 根据商品id集合查询授权平台关系数据信息(POST方式)
     *
     * @param itemIds
     * @return
     */
    @PostMapping("/queryListByItemIdsPost")
    @ApiOperation(value = "根据商品id集合查询授权平台关系数据信息(POST方式)", notes = "根据商品id集合查询授权平台关系数据信息(POST方式)")
    RestResponse<List<ItemChannelRespDto>> queryListByItemIdsPost(@RequestBody List<Long> itemIds);

    /**
     * 根据平台id查询授权平台关系数据
     *
     * @param platformId 客户id
     * @return 根据平台id查询授权平台关系数据
     */
    @GetMapping("/queryByPlatformId")
    @ApiOperation(value = "根据平台id查询授权平台关系数据", notes = "根据平台id查询授权平台关系数据")
    RestResponse<List<ItemChannelRespDto>> queryByPlatformId(@RequestParam("platformId") Long platformId);

    /**
     * 根据商品ID查询客户授权平台明细
     *
     * @param itemId
     * @return 客户授权平台明细数据
     */
    @GetMapping("/queryByItemId")
    @ApiOperation(value = "根据商品ID查询客户授权平台明细", notes = "根据商品ID查询客户授权平台明细")
    RestResponse<List<ItemChannelRespDto>> queryByItemId(@RequestParam("itemId") Long itemId);

}
