package com.yunxi.adapter.api;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.adapter.api.dto.request.ItemExtendAdapterReqDto;
import com.yunxi.adapter.api.dto.response.ItemExtendAdapterRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* 商品扩展参数表服务接口
*
* @author yuangui
* @since 2022-05-11
*/
@Api(tags = {"商品扩展参数表服务（项目适配）"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IItemExtendQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/adapter/itemExtend",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtendAdapterQueryApi {
    /**
     * 商品扩展参数表数据
     * @param reqDto
     * @return
     */
    @PostMapping("/queryParam")
    @ApiOperation(value = "商品扩展参数表数据", notes = "根据filter查询条件查询商品扩展参数表数据，filter=ItemExtendReqDto")
    RestResponse<List<ItemExtendAdapterRespDto>> queryParam(@RequestBody ItemExtendAdapterReqDto reqDto);

    /**
     * 商品扩展参数表分页数据
     *
     * @param itemExtendAdapterReqDto   商品扩展参数表查询条件
     * @return 商品扩展参数表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "商品扩展参数表分页数据", notes = "根据ItemExtendAdapterReqDto查询条件查询商品扩展参数表数据")
    RestResponse<PageInfo<ItemExtendAdapterRespDto>> queryByPage(@RequestBody ItemExtendAdapterReqDto itemExtendAdapterReqDto);
}
