/**
 * @(#)IItemSkuApi 1.0 2019/4/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.yunxi.adapter.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.adapter.api.dto.request.ItemSkuAdapterQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * sku查询
 *
 * @author 元一
 */
@Api(tags = {"商品中心：商品规格服务（项目适配）"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-yunxi-adapter-api--IItemSkuAdapterQueryApi",
        path = "/v1/adapter/item/sku",
        url = "${yundt.cube.center.item.api:}")
public interface IItemSkuAdapterQueryApi {
    /**
     * sku商品列表查询
     * @param itemSkuQueryReqDto
     * @return 返回sku分页信息
     */
    @PostMapping(value = "page")
    @ApiOperation(value = "查询sku分页信息",notes = "查询sku分页信息")
    RestResponse<PageInfo<ItemSkuQueryRespDto>> querySkuPage(@RequestBody ItemSkuAdapterQueryReqDto itemSkuQueryReqDto);

}
