package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author yan.haidong
 * @since 1.0.0
 */
@ApiModel(value = "ItemShopRespDto", description = "商品店铺")
public class ItemShopRespDto implements Serializable {

	private static final long serialVersionUID = -3029711453525165803L;

	@ApiModelProperty(name = "shopId", value = "店铺id")
	private Long shopId;

	/**
	 * 业务类型：业务类型: 1 快递 , 2 020（同城配送、自提）
	 */
	@ApiModelProperty(name = "businessType", value = "业务类型: 1 快递 , 2 020")
	private Integer businessType;
	@ApiModelProperty(name = "shelfType", value = "上架类型：1普通商品 2周期购商品")
	private Integer shelfType;

	/**
	 * 地址坐标：x，y
	 */
	@ApiModelProperty(name = "location", value = "地址坐标")
	private List<LocationDto>   location;

	@ApiModelProperty(name = "templateRegionList", value = "模板区域list")
	private List<TemplateRegionRespDto>  templateRegionList;

	public Integer getShelfType() {
		return shelfType;
	}

	public void setShelfType(Integer shelfType) {
		this.shelfType = shelfType;
	}

	public Long getShopId() {
		return shopId;
	}
	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}
	public Integer getBusinessType() {
		return businessType;
	}
	public void setBusinessType(Integer businessType) {
		this.businessType = businessType;
	}
	public List<LocationDto> getLocation() {
		return location;
	}
	public void setLocation(List<LocationDto> location) {
		this.location = location;
	}
	public List<TemplateRegionRespDto> getTemplateRegionList() {
		return templateRegionList;
	}
	public void
	setTemplateRegionList(List<TemplateRegionRespDto> templateRegionList) {
		this.templateRegionList = templateRegionList;
	}
}