/*
 * @(#)ISupplierApi.java 1.0 2020-03-10
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.communitybuy;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.SupplierModifyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.SupplierReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 供应商表 api
 *
 * @author 简树
 * @since 2.0.0
 */

@Api(tags = {"商品中心:供应商服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-ISupplierApi",
        path = "/v1/supplier",
        url = "${yundt.cube.center.item.api:}")
public interface ISupplierApi {
    /**
     * 新增供应商
     *
     * @param dto
     * @return
     */
    @PostMapping("")
    @ApiOperation(value = "新增供应商", notes = "新增供应商")
    RestResponse<Long> create(@Valid @RequestBody SupplierReqDto dto);

    /**
     * 修改 供应商
     *
     * @param dto 修改内容
     * @return
     */
    @PutMapping("")
    @ApiOperation(value = "修改供应商", notes = "修改供应商")
    RestResponse<Void> modify(@Valid @RequestBody SupplierModifyReqDto dto);


    /**
     * 批量删除供应商
     *
     * @param ids
     * @return
     */
    @DeleteMapping("")
    @ApiOperation(value = "批量删除供应商", notes = "多个id以逗号隔开")
    RestResponse<Void> remove(@RequestParam("ids") String ids);
}
