/*
 * @(#)ItemQueryConditionReqDto.java 1.0 2021年09月13日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemQueryConditionReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/13 23:18
 * @since 0.1.0
 */
@Data
@ApiModel(value = "ItemRelationConditionReqDto", description = "商品查询条件dto")
public class ItemRelationConditionReqDto implements Serializable {

    @ApiModelProperty(name = "itemName", value = "名称")
    private String itemName;
    /**
     *  商品简称
     */
    @ApiModelProperty(name = "displayName", value = "商品简称")
    private String displayName;

    @ApiModelProperty(name = "itemCode", value = "编号")
    private String itemCode;
    /*产品型号*/
    @ApiModelProperty(name = "productModel", value = "产品型号")
    private String productModel;
    /*产品类别*/
    @ApiModelProperty(name = "itemCategory", value = "产品类别")
    private  String itemCategory;
    /*产品大类*/
    @ApiModelProperty(name = "prodLargeClass", value = "产品大类")
    private String prodLargeClass;
    /*燃气种类*/
    @ApiModelProperty(name = "gasClass", value = "燃气种类")
    private String gasClass;
    /*销售组*/
    @ApiModelProperty(name = "saleGroups", value = "销售组")
    private List<String> saleGroups;
    /*商品类型*/
    @ApiModelProperty(name = "types", value = "商品类型,1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private List<Integer> types;

    @ApiModelProperty(name = "dirId",value = "后台类目ID")
    private List dirId;


    @ApiModelProperty(name = "dirPrefixId",value = "前台类目ID")
    private List dirPrefixId;

    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间")
    private String createBeginTime;

    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;

    @ApiModelProperty(name = "updateBeginTime", value = "更新时间开始时间")
    private String updateBeginTime;

    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;

    @ApiModelProperty(name = "pageNum", value = "当前页")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页数")
    private Integer pageSize;
}
