/*
 * @(#)ItemRelationExcelReqDto.java 1.0 2021年09月15日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>Title:ItemRelationExcelReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/15 16:36
 * @since 0.1.0
 */
@ApiModel(value = "ItemRelationExcelReqDto", description = "商品对照关系Excel对象")
public class ItemRelationExcelReqDto extends RequestDto {

    @Excel(name = "物料编码")
    @ApiModelProperty(name = "code", value = "物料编码")
    private String code;

    @ApiModelProperty(name = "channelName", value = "平台名称")
    private String channelName;

    @Excel(name = "店铺编码")
    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    @Excel(name = "平台商品编码")
    @ApiModelProperty(name ="channelItemCode", value = "平台商品编码")
    private String channelItemCode;

    @Excel(name = "平台商品名称")
    @ApiModelProperty(name = "channelItemName", value = "平台商品名称")
    private String channelItemName;

    @Excel(name = "SKU编码")
    @ApiModelProperty(name = "skuId", value = "SKU编码")
    private String skuId;

    @Excel(name = "关联平台")
    @ApiModelProperty(name = "channelCode", value = "关联平台")
    private String channelCode;

    @ApiModelProperty(name = "platformId", value = "平台Id")
    private Long platformId;

    @ApiModelProperty(name = "platformCode", value = "平台编码")
    private String platformCode;

    @ApiModelProperty(name = "platformName", value = "平台名称")
    private String platformName;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getChannelItemName() {
        return channelItemName;
    }

    public void setChannelItemName(String channelItemName) {
        this.channelItemName = channelItemName;
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public String getChannelItemCode() {
        return channelItemCode;
    }

    public void setChannelItemCode(String channelItemCode) {
        this.channelItemCode = channelItemCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
}
