/*
 * @(#)ItemCatrgoryRespDto.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemCatrgoryRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/22 11:46
 * @since 0.1.0
 */
@ApiModel(value = "ItemCatrgoryRespDto", description = "目录信息Dto对象")
public class ItemCategoryRespDto implements Serializable {

    @ApiModelProperty(name = "id",value = "")
    private Long id;
    @ApiModelProperty(name = "dirId",value = "类目ID")
    private Long dirId;
    @ApiModelProperty(name = "code",value = "类目编码")
    private String code;
    @ApiModelProperty(name = "name",value = "类目名称")
    private String name;
    @ApiModelProperty(name = "itemId",value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "itemCode",value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "itemName",value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemRespDtoList",value = "目录商品List")
    private List<CategoryItemRespDto> itemRespDtoList = Lists.newArrayList();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public List<CategoryItemRespDto> getItemRespDtoList() {
        return itemRespDtoList;
    }

    public void setItemRespDtoList(List<CategoryItemRespDto> itemRespDtoList) {
        this.itemRespDtoList = itemRespDtoList;
    }

    @ApiModel(value = "CategoryItemDto", description = "目录商品Dto对象")
    public static class CategoryItemRespDto{

        @ApiModelProperty(name = "dirId",value = "类目ID")
        private Long dirId;
        @ApiModelProperty(name = "itemId",value = "")
        private Long itemId;
        @ApiModelProperty(name = "itemCode",value = "商品编码")
        private String itemCode;
        @ApiModelProperty(name = "itemName",value = "商品名称")
        private String itemName;

        public Long getDirId() {
            return dirId;
        }

        public void setDirId(Long dirId) {
            this.dirId = dirId;
        }

        public Long getItemId() {
            return itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getItemCode() {
            return itemCode;
        }

        public void setItemCode(String itemCode) {
            this.itemCode = itemCode;
        }

        public String getItemName() {
            return itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }
    }

}
