/*
 * @(#)InventoryException.java 1.0 2018-08-22
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.dto.response.dg;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品组合响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "BundleItemRespDto", description = "商品组合响应Dto")
public class BundleItemDgRespDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    /**
     * 商品skuID
     */
    @ApiModelProperty(name = "skuId", value = "规格ID")
    private Long skuId;

    /**
     * 子商品ID
     */
    @ApiModelProperty(name = "subItemId", value = "子商品ID")
    private Long subItemId;

    @ApiModelProperty(name = "subItemName", value = "子商品名称")
    private String subItemName;

    /**
     * 子商品SkuID
     */
    @ApiModelProperty(name = "subSkuId", value = "子商品skuID")
    private Long subSkuId;

    @ApiModelProperty(name = "subSkuCode", value = "子商品skuCode，必填")
    private String subSkuCode;

    @ApiModelProperty(name = "attr", value = "属性")
    private String attr;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "barCode", value = "识别码，选填")
    private String barCode;

    @ApiModelProperty(name = "price", value = "价格(划线价)")
    private BigDecimal price;

    @ApiModelProperty(name = "retailPrice", value = "零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty(name = "storage", value = "安全库存数")
    private Integer safetyStock;

    @ApiModelProperty(name = "shelf_amount", value = "可卖数量")
    private Long shelfAmount;

    @ApiModelProperty(name = "num", value = "组合基数")
    private Integer num;

    @ApiModelProperty(name = "shelfStatus", value = "上架状态")
    private Integer shelfStatus;

    @ApiModelProperty(name = "shopId", value = "上架店铺id")
    private Long shopId;

    @ApiModelProperty(name = "storage", value = "可用库存")
    private Long storage;

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public String getSubSkuCode() {
        return subSkuCode;
    }

    public void setSubSkuCode(String subSkuCode) {
        this.subSkuCode = subSkuCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public Integer getSafetyStock() {
        return safetyStock;
    }

    public void setSafetyStock(Integer safetyStock) {
        this.safetyStock = safetyStock;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSubItemId() {
        return subItemId;
    }

    public void setSubItemId(Long subItemId) {
        this.subItemId = subItemId;
    }

    public Long getSubSkuId() {
        return subSkuId;
    }

    public void setSubSkuId(Long subSkuId) {
        this.subSkuId = subSkuId;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getSubItemName() {
        return subItemName;
    }

    public void setSubItemName(String subItemName) {
        this.subItemName = subItemName;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getShelfStatus() {
        return shelfStatus;
    }

    public void setShelfStatus(Integer shelfStatus) {
        this.shelfStatus = shelfStatus;
    }

    public Long getStorage() {
        return storage;
    }

    public void setStorage(Long storage) {
        this.storage = storage;
    }
}