package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEffectiveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.EffectiveStaticsItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.BdItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemStatisticsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 商品|推荐商品定义服务接口
*
* @author yiyun
* @since 2021-10-07
*/
@Api(tags = {"商品|推荐商品定义服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemStatisticsQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/statistics",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemStatisticsQueryApi {

    /**
    * 根据id查询商品|推荐商品定义
    *
    * @param id 商品|推荐商品定义id
    * @return   商品|推荐商品定义数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品|推荐商品定义", notes = "根据id查询商品|推荐商品定义")
    RestResponse<ItemStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 商品|推荐商品定义分页数据
    *
    * @param filter   商品|推荐商品定义查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品|推荐商品定义分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品|推荐商品定义分页数据", notes = "根据filter查询条件查询商品|推荐商品定义数据，filter=ItemStatisticsReqDto")
    RestResponse<PageInfo<ItemStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryPage")
    @ApiOperation(value = "查询推荐商品 分页数据", notes = "查询推荐商品 分页数据")
    RestResponse<PageInfo<ItemStatisticsRespDto>> queryPage(@RequestBody ItemQueryConditionReqDto queryConditionReqDto);


    /**
     * 根据itemId查询推荐商品详情
     * @param itemId
     * @return
     */
    @GetMapping("/queryStatisticsDetail/{itemId}")
    @ApiOperation(value = "查询商品详情", notes = "查询商品详情")
    RestResponse<BdItemDetailRespDto> queryStatisticsDetail(@PathVariable("itemId") Long itemId);

    @PostMapping("/getEffectiveItem")
    @ApiOperation(value = "取生效中的前50个商品",notes = "取生效中的前50个商品")
    RestResponse<List<EffectiveStaticsItemRespDto>> getEffectiveItem(@RequestBody ItemEffectiveReqDto itemEffectiveReqDto);


}
