/**
 * @(#)ShelfReqDto.java 1.0 2020/1/8
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 上架信息Dto
 *
 * @author 伊泽
 * @since 1.0.0
 */
@Data
@ApiModel(value = "ShelfReqDto", description = "上架信息Dto")
public class ShelfReqDto extends BaseReqDto {

    private Long id;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    /**
     * 0 待上架 1已上架 2已下架
     */
    @ApiModelProperty(name = "status", value = "状态：0 待上架 1已上架 2已下架")
    private Integer status;

    /**
     * 上架时间
     */
    @ApiModelProperty(name = "shelfTime", value = "上架时间")
    private Date shelfTime;

    /**
     * 商户id
     */
    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;


    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;

    /**
     * 兑换金额
     */
    @ApiModelProperty(name = "cashAmount", value = "兑换金额")
    private BigDecimal cashAmount;
    /**
     * 积分
     */
    @ApiModelProperty(name = "cashIntegral", value = "积分")
    private Long cashIntegral;
    /**
     * 兑换数量限制
     */
    @ApiModelProperty(name = "cashLimit", value = "兑换数量限制")
    private Integer cashLimit;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopIds", value = "店铺id列表")
    private List<Long> shopIds;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "skuIds", value = "skuId列表")
    private List<Long> skuIds;
    @ApiModelProperty(name = "type", value = "上架类型：1普通上架 2周期购上架")
    private Integer type;
    /**
     * 规则说明
     */
    @ApiModelProperty(name = "ruleRemark", value = "规则说明")
    private String ruleRemark;
    @ApiModelProperty(name = "itemType", value = "上架类型：1普通商品 2 积分商品")
    private Integer itemType;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;
    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 2 积分商品")
    private Integer busType;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    /**
     * 组织Id
     */
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    @ApiModelProperty(name = "freightTemplateId",value = "运费模板id")
    private Long freightTemplateId;

    @ApiModelProperty(name = "pointsDeduction", value = "是否积分扣减: 1 是, 0 否")
    private Integer pointsDeduction;

    @ApiModelProperty(name = "pointsDeductionRuleReqDto", value = "积分扣减规则")
    private PointsDeductionReqDto pointsDeductionReqDto;

    @ApiModelProperty(name = "bundleItemDtos", value = "组合商品子商品")
    private List<BundleItemReqDto> bundleItemDtos;

    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMinMode", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    @ApiModelProperty(name = "shopAuth", value = "商品sku是否已取消店铺授权：0否 1是")
    private Integer shopAuth;

    /**
     * 首页推荐 0 H5商城 1 Web商城(多选用","分割)
     */
    @ApiModelProperty(name = "homePageDisplay",value = "首页推荐 0 H5商城 1 Web商城(多选用','分割)")
    private String homePageDisplay;

    private String shelfAddress;

}
