/**
 * @(#) ItemStorageQueryRespDto.java 1.0 2018-12-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 商品库存响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemStorageQueryRespDto", description = "商品库存响应Dto")
public class ItemStorageQueryRespDto extends BaseRespDto {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
     * 可用库存数量
     */
    @ApiModelProperty(name = "avaNum", value = "可用库存数量")
    private Long avaNum;
    /**
     * 库存有效日期(今天 未来 yyyy-MM-dd)
     */
    @ApiModelProperty(name = "inventoryEffectiveDate", value = "库存有效日期(今天 未来 yyyy-MM-dd)")
    private String inventoryEffectiveDate;
    @ApiModelProperty(name = "itemShelfRespDto", value = "上架信息")
    private ItemShelfRespDto itemShelfRespDto;

    private Long itemId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
