/*
 * @(#)ItemSapMaterialClassDto.java 1.0 2021年10月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemSapMaterialClassDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/12 2:43
 * @since 0.1.0
 */
@ApiModel(value = "ItemSapMaterialClassDto", description = "北鼎一级品类Dto对象")
public class ItemSapMaterialClassDto implements Serializable {

    @ApiModelProperty(name = "prodOneClass", value = "北鼎一级品类")
    private String prodOneClass;
    @ApiModelProperty(name = "prodOneClassName", value = "北鼎一级品类描述")
    private String prodOneClassName;
    @ApiModelProperty(name = "twoList", value = "北鼎二级品类List")
    private List<TwoList> twoList = Lists.newArrayList();

    public String getProdOneClass() {
        return prodOneClass;
    }

    public void setProdOneClass(String prodOneClass) {
        this.prodOneClass = prodOneClass;
    }

    public String getProdOneClassName() {
        return prodOneClassName;
    }

    public void setProdOneClassName(String prodOneClassName) {
        this.prodOneClassName = prodOneClassName;
    }

    public List<TwoList> getTwoList() {
        return twoList;
    }

    public void setTwoList(List<TwoList> twoList) {
        this.twoList = twoList;
    }

    @ApiModel(value = "TwoList", description = "北鼎二级品类Dto对象")
    public static class TwoList{
        @ApiModelProperty(name = "prodTwoClass", value = "北鼎二级品类")
        private String prodTwoClass;
        @ApiModelProperty(name = "prodTwoClassName", value = "北鼎二级品类描述")
        private String prodTwoClassName;
        @ApiModelProperty(name = "thirdList", value = "北鼎三级品类List")
        private List<ThirdList> thirdList = Lists.newArrayList();

        public String getProdTwoClass() {
            return prodTwoClass;
        }

        public void setProdTwoClass(String prodTwoClass) {
            this.prodTwoClass = prodTwoClass;
        }

        public String getProdTwoClassName() {
            return prodTwoClassName;
        }

        public void setProdTwoClassName(String prodTwoClassName) {
            this.prodTwoClassName = prodTwoClassName;
        }

        public List<ThirdList> getThirdList() {
            return thirdList;
        }

        public void setThirdList(List<ThirdList> thirdList) {
            this.thirdList = thirdList;
        }

        @ApiModel(value = "ThirdList", description = "北鼎三级品类Dto对象")
        public static class ThirdList{
            @ApiModelProperty(name = "prodThirdClass", value = "北鼎三级品类")
            private String prodThirdClass;
            @ApiModelProperty(name = "prodThirdClassName", value = "北鼎三级品类描述")
            private String prodThirdClassName;
            @ApiModelProperty(name = "prodList", value = "北鼎产品型号List")
            private List<ProdList> prodList = Lists.newArrayList();

            public String getProdThirdClass() {
                return prodThirdClass;
            }

            public void setProdThirdClass(String prodThirdClass) {
                this.prodThirdClass = prodThirdClass;
            }

            public String getProdThirdClassName() {
                return prodThirdClassName;
            }

            public void setProdThirdClassName(String prodThirdClassName) {
                this.prodThirdClassName = prodThirdClassName;
            }

            public List<ProdList> getProdList() {
                return prodList;
            }

            public void setProdList(List<ProdList> prodList) {
                this.prodList = prodList;
            }

            @ApiModel(value = "ProdList", description = "北鼎产品型号Dto对象")
            public static class ProdList{
                @ApiModelProperty(name = "prodClassCode", value = "北鼎产品型号")
                private String prodClassCode;
                @ApiModelProperty(name = "prodClassName", value = "北鼎产品名称")
                private String prodClassName;

                @ApiModelProperty(name = "accountingCategoryCode", value = "北鼎核算品类")
                private String accountingCategoryCode;
                @ApiModelProperty(name = "accountingCategoryName", value = "北鼎核算品类描述")
                private String accountingCategoryName;

                public String getProdClassCode() {
                    return prodClassCode;
                }

                public void setProdClassCode(String prodClassCode) {
                    this.prodClassCode = prodClassCode;
                }

                public String getProdClassName() {
                    return prodClassName;
                }

                public void setProdClassName(String prodClassName) {
                    this.prodClassName = prodClassName;
                }

                public String getAccountingCategoryCode() {
                    return accountingCategoryCode;
                }

                public void setAccountingCategoryCode(String accountingCategoryCode) {
                    this.accountingCategoryCode = accountingCategoryCode;
                }

                public String getAccountingCategoryName() {
                    return accountingCategoryName;
                }

                public void setAccountingCategoryName(String accountingCategoryName) {
                    this.accountingCategoryName = accountingCategoryName;
                }
            }
        }
    }
}
