/**
 * @(#)StorageChangeLogTypeEnum 1.0 2019/6/17
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 虚拟库存处理数据类型
 *
 * @author shuangqing  2019/6/17
 */
public enum StorageChangeLogTypeEnum {
    PREEMPTION_STORAGE(1, "预占处理"),
    RETURN_STORAGE(2, "回退处理");

    private Integer status;
    private String desc;

    StorageChangeLogTypeEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDescByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        for (StorageChangeLogTypeEnum typeEnum : StorageChangeLogTypeEnum.values()) {
            if (status.equals(typeEnum.getStatus())) {
                return typeEnum.getDesc();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
