/**
 * @(#)ItemMessage.java 1.0 2020/5/19
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 *
 * @author wu.sheng
 * @date 2020/5/19 16:20
 */
public class ItemMessage implements Serializable {


    private static final long serialVersionUID = -4980907670439037126L;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    /**
     * 操作类型：1上架，0下架
     */
    @ApiModelProperty(name = "operateType", value = "操作类型：1上架，0下架")
    private Integer operateType;

    /**
     * 业务id
     */
    @ApiModelProperty(name = "bizId", value = "业务id")
    private String bizId;

    public ItemMessage() {
    }

    public ItemMessage(Long itemId, Long shopId, Integer operateType) {
        this.itemId = itemId;
        this.shopId = shopId;
        this.operateType = operateType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
