
package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.*;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemExtListInfo;
import com.dtyunxi.yundt.cube.center.item.api.dto.OrderInfoExportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;


/**
 * 商品|产品定义服务接口
 *
 * @author yiyun
 * @since 2021-08-18
 */

@Api(tags = {"商品中心：商品定义扩展服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemExtQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/ext",
        url = "${yundt.cube.center.item.api:}"
)
public interface ITcbjItemExtQueryApi {

    @PostMapping("/queryByCodes")
    @ApiOperation(value = "根据商品编号集合查询商品信息", notes = "根据商品编号集合查询商品信息")
    RestResponse<List<ItemRespDto>> queryByCodes(@RequestBody List<String> codes);


/**
     * 查询商品上架列表
     *
     * @return 返回分页ItemShelfRespDto列表
     */

    @PostMapping(value = "/shelf/list")
    @ApiOperation(value = "查询商品上架列表", notes = "查询商品上架列表")
    RestResponse<List<ItemShelfRespDto>> queryItemShelf(@RequestBody ShelfExtReqDto shelfExtReqDto);


/**
     * 根据商品ID查询商品详情
     *
     * @return 返回ItemDetailDto列表
     */

    @PostMapping(value = "/queryItemDetailByItemIds")
    @ApiOperation(value = "根据商品ID查询商品详情", notes = "根据商品ID查询商品详情,field 显示项：sku,attributes,medias,task表示查询SKU,商品属性,多媒体,定时任务。\ndirId传值表明查询该目录的上架数据，不传则查询商品ID的对应的上架数据。")
    RestResponse<List<ItemDetailRespDto>> queryItemDetailByItemIds(@RequestBody ItemDetailBatchReqDto itemDetailBatchReqDto);
}

