package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemMoveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemStatisticsReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 商品|推荐商品定义服务接口
*
* @author yiyun
* @since 2021-10-07
*/
@Api(tags = {"商品中心：推荐商品定义服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemStatisticsApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/statistics",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemStatisticsApi {

    /**
    * 新增商品|推荐商品定义
    *
    * @param addReqDto 商品|推荐商品定义请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增商品|推荐商品定义", notes = "新增商品|推荐商品定义")
    RestResponse<Long> addItemStatistics(@RequestBody ItemStatisticsReqDto addReqDto);

    /**
     * 批量新增推荐商品
     * @param reqDtos
     * @return
     */
    @PostMapping("/addBatchItemStatistics")
    @ApiOperation(value = "批量新增推荐商品", notes = "批量新增推荐商品")
    RestResponse<Void> addBatchItemStatistics(@RequestBody List<ItemStatisticsReqDto> reqDtos);

    /**
    * 修改商品|推荐商品定义
    *
    * @param modifyReqDto 商品|推荐商品定义请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品|推荐商品定义", notes = "修改商品|推荐商品定义")
    RestResponse<Void> modifyItemStatistics(@RequestBody ItemStatisticsReqDto modifyReqDto);

    /**
    * 删除商品|推荐商品定义
    *
    * @param ids        商品|推荐商品定义删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品|推荐商品定义", notes = "删除商品|推荐商品定义")
    RestResponse<Void> removeItemStatistics(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 删除商品|推荐商品定义
     * @param id
     * @return
     */
    @DeleteMapping("/removeStatistics")
    @ApiOperation(value = "删除商品|推荐商品定义", notes = "删除商品|推荐商品定义")
    RestResponse<Void> removeStatistics(@RequestParam("id") Long id);

    /**
     * 禁用/启用推荐商品
     * @param id
     * @return
     */
    @PostMapping("/enableStatisticsItem")
    @ApiOperation(value = "禁用/启用推荐商品", notes = "禁用/启用推荐商品")
    RestResponse<Void> enableStatisticsItem(@RequestParam("id") Long id);

    /**
     * 上移
     * @return
     */
    @PostMapping("/moveUp")
    @ApiOperation(value = "上移", notes = "上移")
    RestResponse<Void> moveUp(@RequestBody ItemMoveReqDto reqDto);


    /**
     * 下移
     * @return
     */
    @PostMapping("/moveDown")
    @ApiOperation(value = "下移", notes = "下移")
    RestResponse<Void> moveDown(@RequestBody ItemMoveReqDto reqDto);
}
