package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitConversionRecordReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 商品转换关系记录表服务接口
*
* @author author
* @since 2022-09-02
*/
@Api(tags = {"商品转换关系记录表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemUnitConversionRecord",
        url = "${yundt.cube.center.item.api:}")
public interface IItemUnitConversionRecordApi {

    /**
    * 新增商品转换关系记录表
    *
    * @param addReqDto 商品转换关系记录表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增商品转换关系记录表", notes = "新增商品转换关系记录表")
    RestResponse<Long> addItemUnitConversionRecord(@RequestBody ItemUnitConversionRecordReqDto addReqDto);

    /**
    * 修改商品转换关系记录表
    *
    * @param modifyReqDto 商品转换关系记录表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品转换关系记录表", notes = "修改商品转换关系记录表")
    RestResponse<Void> modifyItemUnitConversionRecord(@RequestBody ItemUnitConversionRecordReqDto modifyReqDto);

    /**
    * 删除商品转换关系记录表
    *
    * @param ids        商品转换关系记录表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品转换关系记录表", notes = "删除商品转换关系记录表")
    RestResponse<Void> removeItemUnitConversionRecord(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
