/*
 * @(#)ItemSearchReqDto.java 1.0 2020-07-20
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 搜索条件
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ItemSearchReqDto", description = "商品搜索参数")
public class ItemSearchReqDto {
    @ApiModelProperty(name = "itemId", value = "商品id")
    private String keyword;
    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;
    @ApiModelProperty(name = "prop", value = "属性值,如：20000:29510;20549:296172561")
    private String prop;
    @ApiModelProperty(name = "dirId", value = "目录id")
    private Long dirId;
    @ApiModelProperty(name = "itemType", value = "商品类型：1普通商品2积分商品")
    private Integer itemType;
    @ApiModelProperty(name = "lon", value = "经度")
    private String lon;
    @ApiModelProperty(name = "lat", value = "纬度")
    private String lat;
    @ApiModelProperty(name = "pageNum", value = "当前页数")
    private Integer pageNum;
    @ApiModelProperty(name = "itemId", value = "分页大小")
    private Integer pageSize;

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getProp() {
        return prop;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}