package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDepartmentPriceRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 出厂价同步记录服务接口
*
* @author author
* @since 2022-08-25
*/
@Api(tags = {"出厂价同步记录服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemDepartmentPrice",
        url = "${yundt.cube.center.item.api:}")
public interface IItemDepartmentPriceQueryApi {

    /**
    * 根据id查询出厂价同步记录
    *
    * @param id 出厂价同步记录id
    * @return   出厂价同步记录数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出厂价同步记录", notes = "根据id查询出厂价同步记录")
    RestResponse<ItemDepartmentPriceRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 出厂价同步记录分页数据
    *
    * @param filter   出厂价同步记录查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 出厂价同步记录分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "出厂价同步记录分页数据", notes = "根据filter查询条件查询出厂价同步记录数据，filter=ItemDepartmentPriceReqDto")
    RestResponse<PageInfo<ItemDepartmentPriceRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
