package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品价格请求Dto
 *
 * @author 简树 零星
 * @since 2.0.0
 */
@ApiModel(value = "ItemPriceReqDto", description = "价格信息")
public class ItemPriceReqDto extends BaseReqDto {

    /**
     * id
     */
    @ApiModelProperty(name = "id", value = "id，不填")
    private Long id;
    /**
     * 价格名称
     */
    @ApiModelProperty(name = "name", value = "价格名称，选填")
    private String name;
    /**
     * 币种
     */
    @ApiModelProperty(name = "currency", value = "币种，必填")
    private String currency;
    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格，必填")
    private BigDecimal price;
    /**
     * 消耗积分
     */
    @ApiModelProperty(name = "points", value = "消耗积分，选填")
    private Long points;
    /**
     * 价格体系
     */
    @ApiModelProperty(name = "priceType", value = "价格体系，选填，RETAIL_PRICE：零售价，PRICE：定价（划线价）")
    private String priceType;
    /**
     * 是否激活 0不激活 1 激活
     */
    @ApiModelProperty(name = "isActived", value = "是否激活，选填")
    private Integer isActived;
    /**
     * 商品 skuId
     */
    @ApiModelProperty(name = "skuId", value = "商品 skuId，不填")
    private Long skuId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getPoints() {
        return points;
    }

    public void setPoints(Long points) {
        this.points = points;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public Integer getIsActived() {
        return isActived;
    }

    public void setIsActived(Integer isActived) {
        this.isActived = isActived;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }
}
