package com.yx.tcbj.center.api.constants;

import java.util.Arrays;
import java.util.Optional;

public enum ItemInterceptConfigEnum {
    item(1, "产品"),
    brand(2, "品牌");

    private Integer code;

    private String value;

    ItemInterceptConfigEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ItemInterceptConfigEnum enumOfCode(Integer code) {
        Optional<ItemInterceptConfigEnum> any = Arrays.stream(ItemInterceptConfigEnum.values()).filter(c -> c.getCode().equals(code)).findAny();
        return any.isPresent() ? any.get() : null;
    }
}
