package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.ItemInterceptConfigReqDto;
import com.yx.tcbj.center.api.dto.response.ItemInterceptConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 服务接口
*
* @author ghosn
* @since 2024-06-24
*/
@Api(tags = {"服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-IItemInterceptConfigApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/interceptConfig",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemInterceptConfigApi {

    /**
    * 新增
    *
    * @param addReqDto 请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增", notes = "新增")
    RestResponse<Long> addItemInterceptConfig(@RequestBody ItemInterceptConfigReqDto addReqDto);

    /**
    * 修改
    *
    * @param modifyReqDto 请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyItemInterceptConfig(@RequestBody ItemInterceptConfigReqDto modifyReqDto);

    /**
    * 删除
    *
    * @param ids        删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeItemInterceptConfig(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
