package com.yx.tcbj.center.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.response.ItemInterceptDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 经销商产品商家拦截配置表服务接口
*
* @author ghosn
* @since 2024-06-21
*/
@Api(tags = {"商家产品商家拦截配置表服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IItemInterceptConfigQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/intercept/detail",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemInterceptDetailQueryApi {

    /**
    * 根据id查询经销商产品商家拦截配置表
    *
    * @param id 经销商产品商家拦截配置表id
    * @return   经销商产品商家拦截配置表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询经销商产品商家拦截配置表", notes = "根据id查询经销商产品商家拦截配置表")
    RestResponse<ItemInterceptDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 经销商产品商家拦截配置表分页数据
    *
    * @param filter   经销商产品商家拦截配置表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 经销商产品商家拦截配置表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "经销商产品商家拦截配置表分页数据", notes = "根据filter查询条件查询经销商产品商家拦截配置表数据，filter=ItemInterceptConfigReqDto")
    RestResponse<PageInfo<ItemInterceptDetailRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
