package com.yx.tcbj.center.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.dto.request.ItemAuthExtractCodeReqDto;
import com.yx.tcbj.center.api.dto.request.ItemDetailBatchReqDto;
import com.yx.tcbj.center.api.dto.request.ItemShelfQueryExtReqDto;
import com.yx.tcbj.center.api.dto.request.ShelfExtReqDto;
import com.yx.tcbj.center.api.dto.response.ItemAuthExtractCodeRespDto;
import com.yx.tcbj.center.api.dto.response.ItemShelfQueryExtRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author 迪迦
 * @date 2021-09-26
 */
@Api(tags = {"商品中心查询"})
@FeignClient(
        contextId = "com-yx-tcbj-center-item-api-query-IItemExtQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/ext",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtQueryApi {


    @PostMapping("/queryByCodes")
    @ApiOperation(value = "根据商品编号集合查询商品信息", notes = "根据商品编号集合查询商品信息")
    RestResponse<List<ItemRespDto>> queryByCodes(@RequestBody List<String> codes);

    /**
     * 查询商品上架列表
     *
     * @return 返回分页ItemShelfRespDto列表
     */
    @PostMapping(value = "/shelf/list")
    @ApiOperation(value = "查询商品上架列表", notes = "查询商品上架列表")
    RestResponse<List<ItemShelfRespDto>> queryItemShelf(@RequestBody ShelfExtReqDto shelfExtReqDto);

    /**
     * 根据商品ID查询商品详情
     *
     * @return 返回ItemDetailDto列表
     */
    @PostMapping(value = "/queryItemDetailByItemIds")
    @ApiOperation(value = "根据商品ID查询商品详情", notes = "根据商品ID查询商品详情,\nfield 显示项：sku,attributes,medias,task表示查询SKU,商品属性,多媒体,定时任务。\ndirId传值表明查询该目录的上架数据，不传则查询商品ID的对应的上架数据。")
    RestResponse<List<ItemDetailRespDto>> queryItemDetailByItemIds(@RequestBody ItemDetailBatchReqDto itemDetailBatchReqDto);


    /**
     * 根据商品上架表得到的商品ID等查询商品外部系统编码
     * @author lsw
     * @return 返回商品授权表的extractCode
     */
    @PostMapping(value = "/queryExaractCodeByShelf")
    @ApiOperation(value = "根据商品上架表ID等查询商品外部系统编码", notes = "根据商品上架表得到的商品ID等查询商品外部系统编码")
    RestResponse<List<ItemAuthExtractCodeRespDto>> queryExaractCodeByShelf(@RequestBody ItemAuthExtractCodeReqDto reqDto);

    @PostMapping({"/pageByPost"})
    @ApiOperation(
            value = "分页查询上架商品列表",
            notes = "分页查询上架商品列表",
            response = ItemShelfQueryRespDto.class
    )
    RestResponse<PageInfo<ItemShelfQueryRespDto>> queryShelfItemByPageByPost(@RequestBody ItemShelfQueryExtReqDto itemShelfQueryReqDto, @RequestParam(name = "pageNum",required = false,defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize);

    @PostMapping({"/queryShelfItemByPage"})
    @ApiOperation(
            value = "分页查询上架商品列表",
            notes = "分页查询上架商品列表",
            response = ItemShelfQueryRespDto.class
    )
    RestResponse<PageInfo<ItemShelfQueryExtRespDto>> queryShelfItemByPage(@RequestBody ItemShelfQueryExtReqDto itemShelfQueryReqDto, @RequestParam(name = "pageNum",required = false,defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize);



    @PostMapping("/queryByItemLongCodes")
    @ApiOperation(value = "queryByItemLongCodes", notes = "queryByItemLongCodes")
    RestResponse<List<ItemRespDto>> queryByItemLongCodes(@RequestBody List<String> itemCodes);

}
