package com.yx.tcbj.center.api.dto.request;

import com.yx.tcbj.center.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author liangfa
 * @Description 商品授权查询请求Dto
 * @date 2022-03-02 10:13
 * @since 1.0.0
 */
@ApiModel(value = "ItemSkuInfoReqDto", description = "商品授权查询请求Dto")
public class ItemSkuInfoReqDto extends BaseReqDto {

    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "clientCode", value = "客户编码")
    private String clientCode;

    /**
     * 客户编码数组
     */
    @ApiModelProperty(name = "clientCode", value = "客户编码数组")
    private List<String> clientCodes;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "clientName", value = "客户名称")
    private String clientName;

    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    /**
     * 商品编码数组
     */
    @ApiModelProperty(name = "itemCodes", value = "商品编码数组")
    private List<String> itemCodes;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     * it_item表的状态字段(0已发布 1上架 2下架 3未发布 4禁用状态)
     */
    @ApiModelProperty(name = "status", value = "it_item表的状态字段(0已发布 1上架 2下架 3未发布 4禁用状态)")
    private Integer status;

    /**
     * it_item表的审核状态字段(0草稿 1待审核 2审核通过 3审核拒绝)
     */
    @ApiModelProperty(name = "auditStatus", value = "it_item表的审核状态字段(0草稿 1待审核 2审核通过 3审核拒绝)")
    private Integer auditStatus;

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getClientCode() {
        return clientCode;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public List<String> getClientCodes() {
        return clientCodes;
    }

    public void setClientCodes(List<String> clientCodes) {
        this.clientCodes = clientCodes;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public List<String> getItemCodes() {
        return itemCodes;
    }

    public void setItemCodes(List<String> itemCodes) {
        this.itemCodes = itemCodes;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }
}
