package com.yx.tcbj.center.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.ItemExtendReqDto;
import com.yx.tcbj.center.api.dto.response.ItemExtendRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 商品扩展参数表服务接口
*
* @author yuangui
* @since 2022-05-11
*/
@Api(tags = {"商品扩展参数表服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IItemExtendQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/itemExtend",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtendQueryApi {

    /**
    * 根据id查询商品扩展参数表
    *
    * @param id 商品扩展参数表id
    * @return   商品扩展参数表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品扩展参数表", notes = "根据id查询商品扩展参数表")
    RestResponse<ItemExtendRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 商品扩展参数表数据
     * @param reqDto
     * @return
     */
    @PostMapping("/queryParam")
    @ApiOperation(value = "商品扩展参数表数据", notes = "根据filter查询条件查询商品扩展参数表数据，filter=ItemExtendReqDto")
    RestResponse<List<ItemExtendRespDto>> queryParam(@RequestBody ItemExtendReqDto reqDto);

    /**
    * 商品扩展参数表分页数据
    *
    * @param filter   商品扩展参数表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品扩展参数表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品扩展参数表分页数据", notes = "根据filter查询条件查询商品扩展参数表数据，filter=ItemExtendReqDto")
    RestResponse<PageInfo<ItemExtendRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
