package com.yx.tcbj.center.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ItemBrandAuthReqAddDto {

    @ApiModelProperty(name = "id")
    private Long id;

    @ApiModelProperty(name = "校验类型 按条件校验禁止上架的场景类型\n" +
            "场景1 ppforgid + brandId\n" +
            "场景2 ppforgid + brandId + shopId\n" +
            "场景3 ppforgid + brandId + itemId\n" +
            "场景4 ppforgid + brandId + shopId + itemId'")
    private String authType;

    @ApiModelProperty(name = "销售控制类型  \n" +
            "1 禁售: 不允许上架 不能下单 可以退货\n" +
            "2 禁售禁退货: 无上下架信息 不能下单 不能退货 可以查历史单")
    private String saleControlType;

    @ApiModelProperty(name = "品牌方机构id")
    private Long ppfOrgId;

    @ApiModelProperty(name = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "商品id")
    private Long itemId;
}
