package com.yx.tcbj.center.api.dto.response;

import com.yx.tcbj.center.api.vo.SellerSkuPriceShopVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;

/**
* 供应商和产品的供货价格Eo对象
*
* @author 迪迦
* @since 2021-09-10
*/
@ApiModel(value = "SellerSkuPriceRespDto", description = "供应商和产品的供货价格Eo对象")
public class SellerSkuPriceRespDto extends BaseRespDto {
    /**
    *  卖家（商家/大B）ID
    */
    @ApiModelProperty(name = "sellerId", value = "卖家（商家/大B）ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
    *  买家（客户/小B）ID
    */
    @ApiModelProperty(name = "customerId", value = "买家（客户/小B）ID")
    private Long customerId;
    /**
    *  item ID
    */
    @ApiModelProperty(name = "itemId", value = "item ID")
    private Long itemId;
    /**
    *  SKU ID
    */
    @ApiModelProperty(name = "skuId", value = "SKU ID")
    private Long skuId;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 零售价
     */
    @ApiModelProperty(name = "retailPrice", value = "零售价")
    private BigDecimal retailPrice;
    /**
    *  供货价
    */
    @ApiModelProperty(name = "supplyPrice", value = "供货价")
    private BigDecimal supplyPrice;

    @ApiModelProperty(name = "sellerSkuPriceShopVoList", value = "商铺信息列表")
    private List<SellerSkuPriceShopVo> sellerSkuPriceShopVoList;

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public void setSellerId(Long sellerId){
    this.sellerId = sellerId;
    }
    public Long getSellerId(){
    return this.sellerId;
    }
    public void setCustomerId(Long customerId){
    this.customerId = customerId;
    }
    public Long getCustomerId(){
    return this.customerId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public void setSkuId(Long skuId){
    this.skuId = skuId;
    }
    public Long getSkuId(){
    return this.skuId;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setSupplyPrice(BigDecimal supplyPrice){
    this.supplyPrice = supplyPrice;
    }
    public BigDecimal getSupplyPrice(){
    return this.supplyPrice;
    }

    public List<SellerSkuPriceShopVo> getSellerSkuPriceShopVoList() {
        return sellerSkuPriceShopVoList;
    }

    public void setSellerSkuPriceShopVoList(List<SellerSkuPriceShopVo> sellerSkuPriceShopVoList) {
        this.sellerSkuPriceShopVoList = sellerSkuPriceShopVoList;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
